/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.util;

import com.sap.core.deploy.commons.log.StringFormatLoggerWrapper;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class LandscapeUtils {
    private static final StringFormatLoggerWrapper LOGGER = StringFormatLoggerWrapper.getLogger(LandscapeUtils.class);
    public static final int MAINTENANCE_MODE_REASON_CODE = 1001;
    public static final int CERTMANAGER_MAINTENANCE_MODE_REASON_CODE = 1002;
    public static final String RESPONSE_HEADER_SAP_REASON_CODE = "SAP-Reason-Code";

    public static boolean isInMaintenanceMode(HttpResponse response) {
        Header header;
        LOGGER.info("Starting analysis of received response whether landscape is in maintanence mode", new Object[0]);
        boolean result = false;
        int statusCode = response.getStatusLine().getStatusCode();
        LOGGER.debug("Received response code from server is: %d", statusCode);
        if (statusCode == 503 && (header = response.getFirstHeader(RESPONSE_HEADER_SAP_REASON_CODE)) != null) {
            String codeValue = header.getValue();
            try {
                int reasonCode = Integer.parseInt(codeValue);
                LOGGER.debug("[%s] response header value is: %d", RESPONSE_HEADER_SAP_REASON_CODE, reasonCode);
                result = LandscapeUtils.isReasonCodeForMaintenanceMode(reasonCode);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.warn("The [%s] response header contains value [%s], that cannot be converted to integer number", RESPONSE_HEADER_SAP_REASON_CODE, codeValue);
            }
        }
        LOGGER.info("Final result from response analysis whether landscape is in maintanence mode: %b", result);
        return result;
    }

    private static boolean isReasonCodeForMaintenanceMode(int reasonCode) {
        return reasonCode == 1001 || reasonCode == 1002;
    }
}

