/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.util;

import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStreamWrapper
extends InputStream {
    private long totalBytesRead = 0L;
    private long limit = 0x6400000L;
    private InputStream unlimitedStream;

    public LimitedInputStreamWrapper(InputStream baseStream, long limit) {
        this.unlimitedStream = baseStream;
        if (limit != 0L) {
            this.limit = limit;
        }
    }

    @Override
    public int read() throws IOException {
        int nextByte = this.unlimitedStream.read();
        if (nextByte != -1) {
            ++this.totalBytesRead;
        }
        if (this.limit > 0L && this.totalBytesRead > this.limit) {
            throw new SecurityException("The maximum number of bytes read from the stream has been reached: " + this.limit);
        }
        return nextByte;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int actuallyRead = this.unlimitedStream.read(b);
        if (actuallyRead != -1) {
            this.totalBytesRead += (long)actuallyRead;
        }
        if (this.limit > 0L && this.totalBytesRead > this.limit) {
            throw new SecurityException("The maximum number of bytes read from the stream has been reached: " + this.limit);
        }
        return actuallyRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int actuallyRead = this.unlimitedStream.read(b, off, len);
        if (actuallyRead != -1) {
            this.totalBytesRead += (long)actuallyRead;
        }
        if (this.limit > 0L && this.totalBytesRead > this.limit) {
            throw new SecurityException("The maximum number of bytes read from the stream has been reached: " + this.limit);
        }
        return actuallyRead;
    }

    @Override
    public int available() throws IOException {
        return this.unlimitedStream.available();
    }

    @Override
    public void close() throws IOException {
        this.unlimitedStream.close();
    }

    @Override
    public void mark(int readlimit) {
        this.unlimitedStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.unlimitedStream.markSupported();
    }

    @Override
    public void reset() throws IOException {
        this.unlimitedStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.unlimitedStream.skip(n);
    }
}

