/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ParameterHelper {
    public static List<String> extractArguments(String arguments) {
        ArrayList<String> result = new ArrayList<String>();
        if (arguments == null || arguments.length() == 0) {
            return result;
        }
        STATE state = STATE.UNQUOTED;
        StringTokenizer token = new StringTokenizer(arguments, "\"' ", true);
        StringBuilder current = new StringBuilder();
        boolean quotedToken = false;
        while (token.hasMoreTokens()) {
            String nextToken = token.nextToken();
            switch (state) {
                case SINGLE_QUOTE: {
                    if ("'".equals(nextToken)) {
                        quotedToken = true;
                        state = STATE.UNQUOTED;
                        break;
                    }
                    current.append(nextToken);
                    break;
                }
                case DOUBLE_QUOTE: {
                    if ("\"".equals(nextToken)) {
                        quotedToken = true;
                        state = STATE.UNQUOTED;
                        break;
                    }
                    current.append(nextToken);
                    break;
                }
                default: {
                    if ("'".equals(nextToken)) {
                        state = STATE.SINGLE_QUOTE;
                    } else if ("\"".equals(nextToken)) {
                        state = STATE.DOUBLE_QUOTE;
                    } else if (" ".equals(nextToken)) {
                        if (quotedToken || current.length() != 0) {
                            result.add(current.toString());
                            current = new StringBuilder();
                        }
                    } else {
                        current.append(nextToken);
                    }
                    quotedToken = false;
                }
            }
        }
        if (quotedToken || current.length() != 0) {
            result.add(current.toString());
        }
        if (state != STATE.UNQUOTED) {
            throw new IllegalArgumentException("Quotes do not match in string: " + arguments);
        }
        return result;
    }

    private static enum STATE {
        UNQUOTED,
        SINGLE_QUOTE,
        DOUBLE_QUOTE;

    }
}

