/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class Preconditions {
    public static final Precondition<Object> CHECK_FOR_NULL_PTR = new Precondition<Object>(){

        @Override
        public void check(Object object, String parameterName) {
            if (object == null) {
                throw new IllegalArgumentException("Parameter '" + parameterName + "' must not be null");
            }
        }
    };
    public static final Precondition<Object> CHECK_FOR_EMPTY_STRING = new Precondition<Object>(){

        @Override
        public void check(Object object, String parameterName) {
            if (object.toString().trim().length() == 0) {
                throw new IllegalArgumentException("Parameter '" + parameterName + "' must not be an empty string");
            }
        }
    };
    public static final Precondition<String> CHECK_FOR_DOTS = new Precondition<String>(){

        @Override
        public void check(String object, String parameterName) {
            if (object.trim().contains(".")) {
                throw new IllegalArgumentException("Parameter '" + parameterName + "' must not contain '.' characters");
            }
        }
    };
    public static final Precondition<String> CHECK_FOR_EXISTING_FILE_LOCATION = new Precondition<String>(){

        @Override
        public void check(String object, String parameterName) {
            File file = new File(object);
            if (file.exists()) {
                if (file.isDirectory()) {
                    throw new IllegalArgumentException("Parameter '" + parameterName + "' [" + object + "] is a directory; provided file path must not be a directory and must not point to an existing file");
                }
                throw new IllegalArgumentException("Parameter '" + parameterName + "' [" + object + "] points to an already existing file and will not be overwritten; provided file path must not be a directory and must not point to an existing file");
            }
        }
    };
    public static final Precondition<String> CHECK_FOR_VALID_URL = new Precondition<String>(){

        @Override
        public void check(String object, String parameterName) {
            try {
                new URL(object);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Parameter '" + parameterName + "' [" + object + "] is not a valid URL string", e);
            }
        }
    };
    public static final Precondition<String[]> CHECK_ARRAY_FOR_EMPTY_STRINGS = new Precondition<String[]>(){

        @Override
        public void check(String[] object, String parameterName) {
            String[] stringArray = object;
            int index = 0;
            while (index < stringArray.length) {
                CHECK_FOR_NULL_PTR.check(stringArray[index], String.valueOf(parameterName) + "[" + index + "]");
                CHECK_FOR_EMPTY_STRING.check(stringArray[index], String.valueOf(parameterName) + "[" + index + "]");
                ++index;
            }
        }
    };
    public static final Precondition<Object[]> CHECK_ARRAY_FOR_NULL_PTR = new Precondition<Object[]>(){

        @Override
        public void check(Object[] object, String parameterName) {
            int index = 0;
            while (index < object.length) {
                CHECK_FOR_NULL_PTR.check(object[index], String.valueOf(parameterName) + "[" + index + "]");
                ++index;
            }
        }
    };
    public static final Precondition<Integer> CHECK_FOR_VALID_MAX_ATTEMPTS_NUMBER = new Precondition<Integer>(){

        @Override
        public void check(Integer attempsNumber, String parameterName) {
            if (attempsNumber < 1) {
                throw new IllegalArgumentException(String.format("Parameter '%s' must be >= 1 but is %d", parameterName, attempsNumber));
            }
        }
    };
    public static final Precondition<Long> CHECK_FOR_VALID_SLEEPING_TIME = new Precondition<Long>(){

        @Override
        public void check(Long sleepingTime, String parameterName) {
            if (sleepingTime < 0L) {
                throw new IllegalArgumentException(String.format("Parameter '%s' must be >= 0 but is %d", parameterName, sleepingTime));
            }
        }
    };

    public static <T> void checkArg(T object, String parameterName, Precondition<? super T> ... preconditions) throws IllegalArgumentException {
        CHECK_FOR_NULL_PTR.check(object, parameterName);
        Precondition<? super T>[] preconditionArray = preconditions;
        int n = preconditions.length;
        int n2 = 0;
        while (n2 < n) {
            Precondition<T> precondition = preconditionArray[n2];
            precondition.check(object, parameterName);
            ++n2;
        }
    }

    public static interface Precondition<T> {
        public void check(T var1, String var2);
    }
}

