/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.util;

import com.sap.core.deploy.commons.runtime.Version;
import java.util.Calendar;
import java.util.Comparator;

public class RuntimeVersionsComparator
implements Comparator<Version> {
    @Override
    public int compare(Version o1, Version o2) {
        int result;
        if (o1.getMajor() != o2.getMajor()) {
            return o2.getMajor() - o1.getMajor();
        }
        if (!o1.isDefault() && o2.isDefault()) {
            return 1;
        }
        if (o1.isDefault() && !o2.isDefault()) {
            return -1;
        }
        if (o1.isDeprecated() && !o2.isDeprecated()) {
            return 1;
        }
        if (!o1.isDeprecated() && o2.isDeprecated()) {
            return -1;
        }
        Calendar expDate1 = o1.getExpirationDate();
        Calendar expDate2 = o2.getExpirationDate();
        if (expDate1 != null && expDate2 == null) {
            return 1;
        }
        if (expDate1 == null && expDate2 != null) {
            return -1;
        }
        if (expDate1 != null && expDate2 != null && (result = expDate1.compareTo(expDate2)) != 0) {
            return -result;
        }
        return o1.compareTo(o2);
    }
}

