/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.sap.core.deploy.commons.runtime.RuntimeVersions;
import com.sap.core.deploy.commons.runtime.Version;
import com.sap.core.deploy.commons.util.RuntimeVersionsComparator;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;

public class RuntimeVersionsDeserializer
implements JsonDeserializer<RuntimeVersions> {
    public RuntimeVersions deserialize(JsonElement json, Type type, JsonDeserializationContext jsc) throws JsonParseException {
        RuntimeVersions rv = new RuntimeVersions();
        JsonObject jsonObject = json.getAsJsonObject();
        String runtimeId = jsonObject.get("runtimeId").getAsString();
        rv.setRuntimeId(runtimeId);
        JsonElement displayNameJson = jsonObject.get("displayName");
        if (displayNameJson != null) {
            rv.setDisplayName(displayNameJson.getAsString());
        }
        TreeSet<Version> versionResources = new TreeSet<Version>(new RuntimeVersionsComparator());
        JsonArray array = jsonObject.get("versionResources").getAsJsonArray();
        Iterator i = array.iterator();
        while (i.hasNext()) {
            JsonElement sapJvmVersionsElement;
            JsonElement releaseDateElement;
            JsonElement expirationDateElement;
            JsonElement versionTypeElement;
            JsonElement deprecatedElement;
            Version version = new Version();
            JsonElement e = (JsonElement)i.next();
            JsonObject jo = e.getAsJsonObject();
            JsonElement majorElement = jo.get("major");
            version.setMajor(majorElement.getAsInt());
            JsonElement minorElement = jo.get("minor");
            version.setMinor(minorElement.getAsInt());
            JsonElement microElement = jo.get("micro");
            version.setMicro(microElement.getAsInt());
            JsonElement hotfixElement = jo.get("hotfix");
            version.setHotfix(hotfixElement.getAsInt());
            JsonElement default_Element = jo.get("default_");
            if (default_Element != null) {
                version.setDefault_(default_Element.getAsBoolean());
            }
            if ((deprecatedElement = jo.get("deprecated")) != null) {
                version.setDeprecated(deprecatedElement.getAsBoolean());
            }
            if ((versionTypeElement = jo.get("versionType")) != null) {
                version.setVersionType(versionTypeElement.getAsString());
            }
            if ((expirationDateElement = jo.get("expirationDate")) != null) {
                version.setExpirationDate(this.toCalendar(expirationDateElement.getAsLong()));
            }
            if ((releaseDateElement = jo.get("releaseDate")) != null) {
                version.setReleaseDate(this.toCalendar(releaseDateElement.getAsLong()));
            }
            if ((sapJvmVersionsElement = jo.get("sapJvmVersions")) != null) {
                HashMap sapJvmVersions = (HashMap)new Gson().fromJson(sapJvmVersionsElement, new TypeToken<HashMap<String, String>>(){}.getType());
                version.setSapJvmVersions(sapJvmVersions);
            }
            versionResources.add(version);
        }
        rv.setVersionResources(versionResources);
        return rv;
    }

    private Calendar toCalendar(long date) {
        Calendar c = Calendar.getInstance(Locale.ENGLISH);
        Date d = new Date(date);
        c.setTime(d);
        return c;
    }
}

