/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class SimpleTimeBasedCache {
    public static String RUNTIMES_MAPPING_KEY = "runtimes_mapping";
    private long maxAge;
    private NewLinkedHashMap<Object, Item> store;

    public SimpleTimeBasedCache() {
        this.maxAge = 60000L;
        this.store = new NewLinkedHashMap();
    }

    public SimpleTimeBasedCache(long maxAge) {
        this.maxAge = maxAge;
        this.store = new NewLinkedHashMap();
    }

    public SimpleTimeBasedCache(long maxAge, int maxEntries) {
        this.maxAge = maxAge;
        this.store = new NewLinkedHashMap();
        ((NewLinkedHashMap)this.store).maxEntries = maxEntries;
    }

    public synchronized void put(Object key, Object value) {
        this.store.put(key, new Item(value));
    }

    public synchronized Object get(Object key) {
        Item item = this.getItem(key);
        return item == null ? null : item.payload;
    }

    public synchronized void remove(Object key) {
        this.store.remove(key);
    }

    private Item getItem(Object key) {
        Item item = (Item)this.store.get(key);
        if (item == null) {
            return null;
        }
        if (System.currentTimeMillis() - item.birth > this.maxAge) {
            this.store.remove(key);
            return null;
        }
        return item;
    }

    private static class Item {
        long birth = System.currentTimeMillis();
        Object payload;

        Item(Object payload) {
            this.payload = payload;
        }
    }

    private static class NewLinkedHashMap<Object, Item>
    extends LinkedHashMap<Object, Item> {
        static final long serialVersionUID = 3801424252830210126L;
        private static final int DEFAULT_MAX_ENTRIES = 1000;
        private int maxEntries = 1000;

        private NewLinkedHashMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, Item> eldest) {
            return this.size() > this.maxEntries;
        }
    }
}

