/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.util;

import com.sap.core.deploy.commons.util.ParameterHelper;
import com.sap.core.deploy.commons.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VmArgumentsUtil {
    public static final Map<String, String> ACCEPTED_VM_ARGUMENTS = new HashMap<String, String>();
    public static final String SEPARATOR = ", ";
    public static final String ADDITIONAL = "additional=";

    static {
        ACCEPTED_VM_ARGUMENTS.put("-Xms", "Xms");
        ACCEPTED_VM_ARGUMENTS.put("-Xmx", "Xmx");
        ACCEPTED_VM_ARGUMENTS.put("-XX:PermSize=", "PermSize");
        ACCEPTED_VM_ARGUMENTS.put("-XX:MaxPermSize=", "MaxPermSize");
    }

    public String getVmArgRawValue(String key, String value) {
        String result = "";
        if (value != null && value.length() > 0) {
            if (!"additional".equals(key)) {
                String restoredVmArgKey = this.restoreOriginalVmArgKey(key);
                result = String.valueOf(restoredVmArgKey) + value;
            } else {
                String[] vmArgs = this.getAdditionalVmArgumentRawValues(value);
                int index = 0;
                while (index < vmArgs.length - 1) {
                    result = String.valueOf(result) + vmArgs[index] + " ";
                    ++index;
                }
                result = String.valueOf(result) + vmArgs[vmArgs.length - 1];
            }
        }
        return result;
    }

    private String restoreOriginalVmArgKey(String vmArgKeyFromBackend) {
        for (Map.Entry<String, String> entry : ACCEPTED_VM_ARGUMENTS.entrySet()) {
            if (!entry.getValue().equals(vmArgKeyFromBackend)) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Unknown VM argument key returned from backend: " + vmArgKeyFromBackend);
    }

    public List<String> getAdditionalVmArgValues(String value) {
        ArrayList<String> result = new ArrayList<String>();
        if (value != null && value.length() > 0) {
            String[] vmArgs;
            String[] stringArray = vmArgs = this.getAdditionalVmArgumentRawValues(value);
            int n = vmArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String vmArg = stringArray[n2];
                result.add(vmArg);
                ++n2;
            }
        }
        return result;
    }

    private String[] getAdditionalVmArgumentRawValues(String additionalVmArgsFromBackend) {
        String[] vmArgs = additionalVmArgsFromBackend.split("\", \"");
        vmArgs[0] = StringUtils.removePrefix(vmArgs[0], "\"");
        int lastIndex = vmArgs.length - 1;
        vmArgs[lastIndex] = StringUtils.removeSuffix(vmArgs[lastIndex], "\"");
        this.processVMArgsWithWhiteSpaces(vmArgs);
        return vmArgs;
    }

    private void processVMArgsWithWhiteSpaces(String[] vmArgs) {
        int index = 0;
        while (index < vmArgs.length) {
            if (vmArgs[index].contains(" ")) {
                vmArgs[index] = "'" + vmArgs[index] + "'";
            }
            ++index;
        }
    }

    public String joinVmArguments(List<String> vmArgsList) {
        StringBuilder sb = new StringBuilder();
        if (vmArgsList != null) {
            String delimiter = "";
            for (String vmArg : vmArgsList) {
                if (vmArg == null || "".equals(vmArg)) continue;
                sb.append(delimiter);
                sb.append(vmArg);
                delimiter = " ";
            }
        }
        return sb.toString();
    }

    public String convertRawVmArgumentsToFormatExpectedByBackend(String vmArguments) {
        if (this.areProcessedVmArguments(vmArguments)) {
            return vmArguments;
        }
        return this.processVmArguments(ParameterHelper.extractArguments(vmArguments));
    }

    public String processVmArguments(List<String> vmArguments) {
        String argumentsString = "";
        StringBuilder arguments = new StringBuilder();
        if (vmArguments != null) {
            ArrayList<String> memory = new ArrayList<String>();
            ArrayList<String> additional = new ArrayList<String>();
            for (String argument : vmArguments) {
                boolean memoryArgumentFound = false;
                for (String acceptedArg : ACCEPTED_VM_ARGUMENTS.keySet()) {
                    if (!argument.startsWith(acceptedArg)) continue;
                    memoryArgumentFound = true;
                    memory.add(String.valueOf(ACCEPTED_VM_ARGUMENTS.get(acceptedArg)) + "=" + argument.substring(acceptedArg.length()));
                    break;
                }
                if (memoryArgumentFound) continue;
                additional.add(argument);
            }
            for (String memoryArgument : memory) {
                arguments.append(memoryArgument);
                arguments.append(SEPARATOR);
            }
            if (!additional.isEmpty()) {
                arguments.append(ADDITIONAL);
                for (String additionalArgument : additional) {
                    arguments.append("\"");
                    arguments.append(additionalArgument);
                    arguments.append("\"");
                    arguments.append(SEPARATOR);
                }
            }
            if ((argumentsString = arguments.toString()).endsWith(SEPARATOR)) {
                argumentsString = argumentsString.substring(0, argumentsString.length() - SEPARATOR.length());
            }
        }
        return argumentsString;
    }

    private boolean areProcessedVmArguments(String argument) {
        return this.areProcessedAdditionalVmArguments(argument) || this.areProcessedMemoryVmArguments(argument);
    }

    private boolean areProcessedAdditionalVmArguments(String argument) {
        return argument.contains(ADDITIONAL);
    }

    private boolean areProcessedMemoryVmArguments(String argument) {
        boolean rawVmArgumentExists = false;
        boolean processedVmArgumentExists = false;
        for (String rawVmArgPrefix : ACCEPTED_VM_ARGUMENTS.keySet()) {
            String processedVmArgPrefix = String.valueOf(ACCEPTED_VM_ARGUMENTS.get(rawVmArgPrefix)) + "=";
            if (argument.contains(rawVmArgPrefix)) {
                rawVmArgumentExists = true;
            }
            if (!argument.contains(processedVmArgPrefix)) continue;
            processedVmArgumentExists = true;
        }
        return !rawVmArgumentExists && processedVmArgumentExists;
    }
}

