/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.validator;

public class TomcatParamsValidator {
    public static final String COMPRESSION_NOT_ENABLED_WARNING = "Warning: Gzip response compression is not enabled. If you want to enable it please specify the compression parameter.";
    public static final String COMPRESSION_NOT_ENABLED_WARNING_FOR_SINGLE_PARAMS = "Warning: Parameter %s is specified but gzip response compression is not enabled. To enable it, set parameter --compression to 'on'.";
    public static final String COMPRESSION_NOT_ENABLED_WARNING_FOR_MULTIPLE_PARAMS = "Warning: Parameters %s are specified but gzip response compression is not enabled. To enable it, set parameter --compression to 'on'.";
    public static final String TOMCAT_PARAMETER_NOT_SUPPORTED_FOR_RUNTIME_WARNING = "Warning: Parameter %s is not supported for runtime [%s].";
    public static final String GZIP_NOT_SUPPORTED_FOR_RUNTIME_WARNING = "Warning: Gzip response compression configuration is not supported for the specified runtime type [%s].";
    public static final String TOMCAT_PARAMETER_INVALID_PARAM_ERROR = "%s contains unallowed characters";
    public static final String COMPRESSION_MATCHER = "^on$|^off$|^force$|^[\\d]*$";
    public static final String COMPRESSABLE_MIME_TYPE = "^[^<>\\*]+/[^<>\\*]+$";
    public static final String NUMBER = "^[\\d]*$";
    public static final String CONNECTION_TIMEOUT = "^-1$|^[\\d]*$";

    public static boolean isCompressionValid(String compression) {
        return compression == null || compression.toLowerCase().matches(COMPRESSION_MATCHER);
    }

    public static boolean isCompressableMimeTypeValid(String compressableMimeType) {
        return compressableMimeType == null || compressableMimeType.matches(COMPRESSABLE_MIME_TYPE);
    }

    public static boolean isPositiveNumber(String value) {
        return value == null || value.matches(NUMBER);
    }

    public static boolean isConnectionTimeoutValid(String value) {
        return value == null || value.matches(CONNECTION_TIMEOUT);
    }
}

