/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.tomcat.valve;

import com.sap.jdsr.passport.DSRPassport;
import com.sap.jdsr.passport.EncodeDecode;
import com.sap.jdsr.util.ConvertHelper;
import com.sap.js.statistics.api.StatisticsTrigger;
import com.sap.js.statistics.api.providers.StatisticsProvider;
import com.sap.js.statistics.api.providers.StatisticsProviderExternalRecords;
import com.sap.js.statistics.api.writer.DSRHTTPRecord;
import com.sap.js.statistics.impl.providers.RequestTracingValveHandler;
import com.sap.js.statistics.impl.providers.StatisticsThreadContext;
import com.sap.js.statistics.impl.providers.StatisticsTriggerProvider;
import com.sap.js.statistics.impl.util.StatisticsUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.valves.ValveBase;

public class RequestTracingValve
extends ValveBase {
    private static final String DSR_PASSPORT_KEY = "com.sap.jdsr.writer.DsrIPassport";
    private static final String ACCOUNT_NOTE_NAME = "account";
    private static final String OSGI_INSTALL_AREA_PROP = "osgi.install.area";
    private final RequestTracingValveHandler requestTracingValveHandler = RequestTracingValveHandler.getInstance();
    private Map<ClassLoader, Set<StatisticsProvider>> statisticsProvedersPerApplication = new HashMap<ClassLoader, Set<StatisticsProvider>>();
    private Map<ClassLoader, Set<StatisticsProviderExternalRecords>> statisticsProvedersExternalRecordsPerApplication = new HashMap<ClassLoader, Set<StatisticsProviderExternalRecords>>();

    public RequestTracingValve() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            RequestTracingValve requestTracingValve;
            StatisticsTrigger statisticsTrigger;
            DSRPassport passport = this.getDsrPassport(request);
            if (passport != null) {
                this.requestTracingValveHandler.setCurrentPassport(passport);
                request.setNote(DSR_PASSPORT_KEY, (Object)passport);
            }
            if (!(statisticsTrigger = StatisticsTriggerProvider.getStatisticsTrigger()).shouldEnableStatistics(request)) {
                this.callNextValve(request, response);
                return;
            }
            StatisticsThreadContext context = this.initializeStatisticsContext(request, passport);
            ClassLoader appClassLoader = request.getContext().getLoader().getClassLoader();
            if (this.statisticsProvedersPerApplication.get(appClassLoader) == null && !this.isRunningInOsgi()) {
                requestTracingValve = this;
                synchronized (requestTracingValve) {
                    if (this.statisticsProvedersPerApplication.get(appClassLoader) == null) {
                        this.loadStatisticsProviders(request);
                    }
                }
            }
            if (this.statisticsProvedersExternalRecordsPerApplication.get(appClassLoader) == null && !this.isRunningInOsgi()) {
                requestTracingValve = this;
                synchronized (requestTracingValve) {
                    if (this.statisticsProvedersExternalRecordsPerApplication.get(appClassLoader) == null) {
                        this.loadStatisticsProvidersExternalRecords(request);
                    }
                }
            }
            this.requestTracingValveHandler.requestStarted((Collection)this.statisticsProvedersPerApplication.get(appClassLoader), (Collection)this.statisticsProvedersExternalRecordsPerApplication.get(appClassLoader));
            this.callNextValve(request, response);
            context.setMemoryConsumption(this.calculateConsumedMemory(context));
            context.setCpuTime(this.calculateCpuUsage(context));
            context.setUserId(request.getRemoteUser());
            context.setAccount((String)request.getNote(ACCOUNT_NOTE_NAME));
            context.setAdditionalStatisticsProviders((Collection)this.statisticsProvedersPerApplication.get(appClassLoader));
            context.setAdditionalStatisticsProvidersExternalRecords((Collection)this.statisticsProvedersExternalRecordsPerApplication.get(appClassLoader));
            if (!request.isAsyncStarted()) {
                context.setReceivedBytes(response.getContentWritten());
                context.setProcessingTime(RequestTracingValve.calculateProcessingTime(context));
                this.requestTracingValveHandler.requestFinished(context);
            } else {
                AsyncContext asyncContext = request.getAsyncContext();
                asyncContext.addListener((AsyncListener)new RequestTracingAsyncListener(context));
            }
        }
        finally {
            this.requestTracingValveHandler.setCurrentPassport(null);
            request.removeNote(ACCOUNT_NOTE_NAME);
        }
    }

    private void callNextValve(Request request, Response response) throws IOException, ServletException {
        Valve nextValve = this.getNext();
        if (nextValve != null) {
            nextValve.invoke(request, response);
        }
    }

    private DSRPassport getDsrPassport(Request request) {
        String hexPassport = request.getHeader("SAP-PASSPORT");
        if (hexPassport == null) {
            return null;
        }
        byte[] bytesPass = ConvertHelper.hexToByteArray((String)hexPassport);
        if (bytesPass == null) {
            return null;
        }
        return EncodeDecode.decodeBytePassport((byte[])bytesPass);
    }

    private StatisticsThreadContext initializeStatisticsContext(Request request, DSRPassport passport) {
        StatisticsThreadContext context = new StatisticsThreadContext();
        context.setPassport(passport);
        String requestUrl = request.getRequestURL().toString();
        context.setAction(requestUrl);
        long cpuTime = StatisticsUtil.getCurrentCpuTime();
        long memoryConsumption = StatisticsUtil.getMemoryConsumption();
        long startTime = request.getCoyoteRequest().getStartTime();
        context.setCpuTime(cpuTime);
        context.setMemoryConsumption(memoryConsumption);
        context.setStartTime(startTime);
        context.setSentBytes(request.getCoyoteRequest().getContentLengthLong());
        context.setDsrHttpRecord(this.createDsrHttpRecord(request));
        return context;
    }

    private boolean isRunningInOsgi() {
        return System.getProperty(OSGI_INSTALL_AREA_PROP) != null;
    }

    private void loadStatisticsProviders(Request request) {
        ClassLoader classloader = request.getContext().getLoader().getClassLoader();
        ServiceLoader<StatisticsProvider> loader = ServiceLoader.load(StatisticsProvider.class, classloader);
        HashSet<StatisticsProvider> statisticsProviders = new HashSet<StatisticsProvider>();
        for (StatisticsProvider provider : loader) {
            if (!provider.getClass().getClassLoader().equals(classloader)) continue;
            statisticsProviders.add(provider);
        }
        this.statisticsProvedersPerApplication.put(classloader, statisticsProviders);
    }

    private void loadStatisticsProvidersExternalRecords(Request request) {
        ClassLoader classloader = request.getContext().getLoader().getClassLoader();
        ServiceLoader<StatisticsProviderExternalRecords> loader = ServiceLoader.load(StatisticsProviderExternalRecords.class, classloader);
        HashSet<StatisticsProviderExternalRecords> statisticsProvidersExternalRecords = new HashSet<StatisticsProviderExternalRecords>();
        for (StatisticsProviderExternalRecords provider : loader) {
            if (!provider.getClass().getClassLoader().equals(classloader)) continue;
            statisticsProvidersExternalRecords.add(provider);
        }
        this.statisticsProvedersExternalRecordsPerApplication.put(classloader, statisticsProvidersExternalRecords);
    }

    private DSRHTTPRecord createDsrHttpRecord(Request request) {
        DSRHTTPRecord dsrhttpRecord = new DSRHTTPRecord();
        Enumeration headers = request.getHeaderNames();
        if (headers != null) {
            LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>(20);
            while (headers.hasMoreElements()) {
                String headerName = (String)headers.nextElement();
                if (headerName == null || headerName.trim().isEmpty()) continue;
                Enumeration values = request.getHeaders(headerName);
                if (values == null) {
                    headerMap.put(headerName, null);
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                String separator = "";
                while (values.hasMoreElements()) {
                    String value = (String)values.nextElement();
                    if (value == null || value.trim().isEmpty()) continue;
                    if (!separator.isEmpty()) {
                        sb.append(separator);
                    }
                    sb.append(value.trim());
                    separator = ",";
                }
                headerMap.put(headerName, sb.length() == 0 ? null : sb.toString());
            }
            dsrhttpRecord.setRequestHeaders(headerMap);
        }
        return dsrhttpRecord;
    }

    private long calculateConsumedMemory(StatisticsThreadContext context) {
        return StatisticsUtil.getMemoryConsumption() - context.getMemoryConsumption();
    }

    private long calculateCpuUsage(StatisticsThreadContext context) {
        return StatisticsUtil.getCurrentCpuTime() - context.getCpuTime();
    }

    private static long calculateProcessingTime(StatisticsThreadContext context) {
        return StatisticsUtil.getCurrentTime() - context.getStartTime();
    }

    private static class RequestTracingAsyncListener
    implements AsyncListener {
        private static final String HEADER_CONTENT_LENGTH = "Content-Length";
        private StatisticsThreadContext context;

        RequestTracingAsyncListener(StatisticsThreadContext context) {
            this.context = context;
        }

        public void onComplete(AsyncEvent event) throws IOException {
            ServletRequest request = event.getAsyncContext().getRequest();
            long sentBytes = this.getSentBytes(request);
            ServletResponse response = event.getAsyncContext().getResponse();
            long receivedBytes = this.getReceivedBytes(response);
            this.context.setSentBytes(sentBytes);
            this.context.setReceivedBytes(receivedBytes);
            this.context.setProcessingTime(RequestTracingValve.calculateProcessingTime(this.context));
            RequestTracingValveHandler.getInstance().requestFinished(this.context);
        }

        private long getSentBytes(ServletRequest request) throws IOException {
            long sentBytes = -1L;
            if (request instanceof RequestFacade) {
                sentBytes = this.getSentBytesFromRequest(request);
            } else if (request instanceof HttpServletRequest) {
                sentBytes = this.getSentBytesFromHeader(request);
            }
            return sentBytes;
        }

        private long getSentBytesFromRequest(ServletRequest request) {
            long sentBytes = -1L;
            RequestFacade facade = (RequestFacade)request;
            Request internalRequest = this.getRequest(facade);
            sentBytes = internalRequest != null ? internalRequest.getCoyoteRequest().getBytesRead() : (long)facade.getContentLength();
            return sentBytes;
        }

        private long getSentBytesFromHeader(ServletRequest request) throws IOException {
            String lengthHeaderValue = ((HttpServletRequest)request).getHeader(HEADER_CONTENT_LENGTH);
            long sentBytes = -1L;
            if (lengthHeaderValue != null && lengthHeaderValue.length() > 0) {
                try {
                    sentBytes = Integer.parseInt(lengthHeaderValue);
                }
                catch (NumberFormatException e) {
                    throw new IOException("Request's Content-Length value [" + lengthHeaderValue + "] not a number", e);
                }
            }
            return sentBytes;
        }

        /*
         * Exception decompiling
         */
        private Request getRequest(RequestFacade requestFacade) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private long getReceivedBytes(ServletResponse response) throws IOException {
            long receivedBytes = -1L;
            if (response instanceof ResponseFacade) {
                receivedBytes = this.getReceivedBytesFromResponse(response);
            } else if (response instanceof HttpServletResponse) {
                receivedBytes = this.getReceivedBytesFromHeader(response, receivedBytes);
            }
            return receivedBytes;
        }

        private long getReceivedBytesFromResponse(ServletResponse response) {
            ResponseFacade facade = (ResponseFacade)response;
            long receivedBytes = facade.getContentWritten();
            return receivedBytes;
        }

        private long getReceivedBytesFromHeader(ServletResponse response, long receivedBytes) throws IOException {
            String lengthHeaderValue = ((HttpServletResponse)response).getHeader(HEADER_CONTENT_LENGTH);
            if (lengthHeaderValue != null && lengthHeaderValue.length() > 0) {
                try {
                    receivedBytes = Long.parseLong(lengthHeaderValue);
                }
                catch (NumberFormatException e) {
                    throw new IOException("Response'sContent-Length value [" + lengthHeaderValue + "] not a number", e);
                }
            }
            return receivedBytes;
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
        }
    }
}

