/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.monitoring.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.sap.core.monitoring.cmd.message.CommandMessages;
import com.sap.core.monitoring.web.client.MonitoringBasicAuthClient;
import com.sap.core.monitoring.web.client.MonitoringResponse;
import com.sap.core.monitoring.web.common.CustomChecksInfo;
import com.sap.core.monitoring.web.common.CustomGroupInfo;
import com.sap.core.monitoring.web.common.Type;
import com.sap.jpaas.infrastructure.console.command.RemoteCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import com.sap.jpaas.infrastructure.console.validator.SACValidator;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.log4j.Logger;

public abstract class AbstractCommand
extends RemoteCommand {
    private static final String UTF_8 = "UTF-8";
    public static final String DEFAULT_AVAILABILITY_SERVICE_NAME = "Availability Check";
    public static String ORCHESTRATOR_SUBDOMAIN = "orchestrator.";
    public static String MONITORING_COMMANDS_GROUP = "monitoring";
    public static String DEFAULT_PROTOCOL = "https";
    protected static final String NULL_VALUE = "NULL";
    protected static final String WARNING_CUSTOM_VARIABLE = "_HTTPWARNING";
    protected static final String CRITICAL_CUSTOM_VARIABLE = "_HTTPCRITICAL";
    protected static final String RELATIVE_URL_CUSTOM_VARIABLE = "_HTTPURI";
    protected static final String ABSOLUTE_URL_CUSTOM_VARIABLE = "_HTTPURL";
    protected static final String RELATIVE_URL_SERVICE_TEMPLATE = "check-https-service-template";
    protected static final String ABSOLUTE_URL_SERVICE_TEMPLATE = "check-https-service-url-template";
    protected static final String INHERITABLE_CUSTOM_VARIABLE = "_INHERITABLE";
    protected static final String METRIC_NAME_CUSTOM_VARIABLE = "_METRIC_NAME";
    protected static final String JMX_ARGUMENTS_CUSTOM_VARIABLE = "_JMXARGUMENTS";
    protected static final String JMX_WARNING_CUSTOM_VARIABLE = "_JMXWARNING";
    protected static final String JMX_CRITICAL_CUSTOM_VARIABLE = "_JMXCRITICAL";
    protected static final String JMX_OBJECT_NAME_CUSTOM_VARIABLE = "_JMXOBJECTNAME";
    protected static final String JMX_ATTRIBUTE_CUSTOM_VARIABLE = "_JMXATTRIBUTENAME";
    protected static final String JMX_OPERATION_CUSTOM_VARIABLE = "_JMXOPERATION";
    protected static final String JMX_UNIT_CUSTOM_VARIABLE = "_METRIC_UNIT";
    protected static final String JMX_COMPOUND_KEY_CUSTOM_VARIABLE = "_JMXCOMPOUNDKEY";
    protected static final String JMX_SERVICE_TEMPLATE = "check-jmx-service-generic-template";
    protected static final String PARAM_HANA_PACKAGE_DESCRIPTION = "Application name for Java applications or instance-name:application for HANA XS applications.\nInstance name refers to productive or trial SAP HANA instance database name.";
    protected static final String JMX_IS_VOLATILE = "is_volatile";
    protected static final String JMX_NOTIFICATION_OPTIONS = "notification_options";
    protected static final String JMX_FLAP_DETECTION_ENABLED = "flap_detection_enabled";
    protected static final String JMX_MAX_CHECK_ATTEMPTS = "max_check_attempts";
    protected static final String PARAM_URL = "-U";
    protected static final String PARAM_URL_LONG = "--url";
    protected static final String PARAM_URL_DESCRIPTION = "Absolute or relative application URL";
    protected static final String PARAM_CUSTOM_VARIABLE_CHECK_TYPE = "_CHECK_TYPE";
    protected static final String PARAM_CUSTOM_VARIABLE_AVAILABILITY = "APPLICATION AVAILABILITY";
    protected static final String PARAM_CUSTOM_VARIABLE_RUNTIME = "_HCP_RUNTIME";
    protected static final String PARAM_CUSTOM_VARIABLE_RUNTIME_JAVA = "JAVA";
    protected static final String PARAM_CUSTOM_VARIABLE_RUNTIME_HANAXS = "HANAXS";
    protected static final String NAGIOS_DISABLED_VALUE = "0";
    protected static final String NAGIOS_ENABLED_VALUE = "1";
    protected static final String NAGIOS_NOTIFICATION_OPTIONS_VALUE = "u,c,w";
    protected MonitoringBasicAuthClient monitoringClient;
    @Parameter(names={"-a", "-account", "--account"}, description="Name of the subaccount for which you provide user and password", validateWith=SACValidator.class)
    protected String account;
    @Parameter(names={"-c", "-component", "--component"}, description="Component", validateWith=SACValidator.class, hidden=true)
    protected String component = null;
    private static final Logger LOGGER = Logger.getLogger(AbstractCommand.class);
    private static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 300000;

    public String getAccount() {
        return this.account;
    }

    protected void setAccount(String account) {
        this.account = account;
    }

    public abstract String getApplication();

    public String getComponent() {
        return this.component;
    }

    @Override
    public void init() throws CommandException {
        super.init();
        if (this.getAccount() == null) {
            throw new ParameterException("Account is a required parameter! ");
        }
        if (this.getComponent() != null && this.getApplication() == null) {
            throw new ParameterException("Component is specified, but application is missing");
        }
        this.monitoringClient = this.getMonitoringClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() throws CommandException {
        try {
            this.executeCommand();
        }
        finally {
            if (this.monitoringClient != null) {
                this.monitoringClient.close();
            }
        }
    }

    protected abstract void executeCommand() throws CommandException;

    private MonitoringBasicAuthClient getMonitoringClient() {
        URL monitoringSei = this.getMonitoringSei();
        if (monitoringSei == null) {
            throw new ParameterException("Invalid host provided " + this.host);
        }
        HttpClient client = this.createWebClient(monitoringSei);
        return new MonitoringBasicAuthClient(client, monitoringSei);
    }

    private HttpClient createWebClient(URL monitoringSei) {
        HttpClient httpClient = this.getHttpClient(monitoringSei.toString(), 20000);
        this.setHttpClientParams(httpClient);
        return httpClient;
    }

    private void setHttpClientParams(HttpClient httpClient) {
        HttpParams params = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout(params, 30000);
        HttpConnectionParams.setSoTimeout(params, 300000);
        params.setParameter("http.protocol.version", HttpVersion.HTTP_1_1);
        params.setParameter("http.protocol.content-charset", UTF_8);
    }

    protected URL getMonitoringSei() {
        String protocol = this.getProtocol();
        String host = this.getTargetHost();
        URL monitoringUrl = null;
        try {
            monitoringUrl = new URL(protocol, host, "/");
        }
        catch (MalformedURLException e) {
            LOGGER.error(e.getMessage());
        }
        return monitoringUrl;
    }

    protected abstract String getTargetHost();

    private String getProtocol() {
        try {
            URL url = new URL(this.host);
            return url.getProtocol();
        }
        catch (MalformedURLException e) {
            return DEFAULT_PROTOCOL;
        }
    }

    @Override
    public void cleanup() throws CommandException {
        if (this.monitoringClient != null) {
            this.monitoringClient.close();
        }
    }

    @Override
    public String getGroup() {
        return MONITORING_COMMANDS_GROUP;
    }

    protected Type calculateType() {
        Type type = Type.SPACE;
        if (this.getApplication() != null) {
            type = Type.APPLIANCE;
        }
        if (this.getComponent() != null) {
            type = Type.COMPONENT;
        }
        return type;
    }

    protected boolean isAbsolute(String url) {
        if (url == null) {
            return false;
        }
        try {
            URI uri = new URI(url);
            return uri.isAbsolute();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    protected abstract String getMessageGroup();

    protected String getMessageSubGroup() {
        return null;
    }

    protected void handleErrorResponse(MonitoringResponse<?> response) throws CommandException {
        int status = response.getStatus();
        CommandMessages messages = CommandMessages.getInstance(this.getMessageGroup());
        String outputString = null;
        int exitCode = 0;
        switch (status) {
            case 400: {
                exitCode = messages.getExitCode("400");
                outputString = this.getMessage("400");
                break;
            }
            case 401: {
                exitCode = messages.getExitCode("401");
                outputString = this.getMessage("401");
                break;
            }
            case 403: {
                exitCode = messages.getExitCode("403");
                this.logWarning("403", this.user, this.getAccount(), this.getApplication(), this.getComponent());
                break;
            }
            case 404: {
                exitCode = messages.getExitCode("404");
                if (this.getAccount() != null && this.getApplication() == null && this.getComponent() == null) {
                    this.logWarning("404a", this.getAccount());
                    break;
                }
                if (this.getAccount() != null && this.getApplication() != null && this.getComponent() == null) {
                    this.logWarning("404b", this.getAccount(), this.getApplication());
                    break;
                }
                if (this.getAccount() != null && this.getApplication() != null && this.getComponent() == null) {
                    this.logWarning("404c", this.getAccount(), this.getApplication(), this.getComponent());
                    break;
                }
                this.logWarning("404", this.getAccount(), this.getApplication(), this.getComponent());
                break;
            }
            case 409: {
                exitCode = messages.getExitCode("409");
                this.logWarning("409");
                break;
            }
            case 500: {
                String messageSubGroup = this.getMessageSubGroup();
                if (messageSubGroup != null) {
                    if ("recipients.set".equals(messageSubGroup)) {
                        exitCode = messages.getExitCode("500a");
                        outputString = this.getMessage("500a");
                        break;
                    }
                    if ("recipients.list".equals(messageSubGroup)) {
                        exitCode = messages.getExitCode("500b");
                        outputString = this.getMessage("500b");
                        break;
                    }
                    if ("availability.create".equals(messageSubGroup)) {
                        exitCode = messages.getExitCode("500a");
                        outputString = this.getMessage("500a");
                        break;
                    }
                    if ("availability.delete".equals(messageSubGroup)) {
                        exitCode = messages.getExitCode("500b");
                        outputString = this.getMessage("500b");
                        break;
                    }
                    if ("jmx.create".equals(messageSubGroup)) {
                        exitCode = messages.getExitCode("500a");
                        outputString = this.getMessage("500a");
                        break;
                    }
                    if (!"jmx.delete".equals(messageSubGroup)) break;
                    exitCode = messages.getExitCode("500b");
                    outputString = this.getMessage("500b");
                    break;
                }
                exitCode = messages.getExitCode("500");
                outputString = this.getMessage("500");
                break;
            }
            case 413: {
                exitCode = messages.getExitCode("413");
                outputString = this.getMessage("413");
                break;
            }
            default: {
                exitCode = messages.getExitCode("600");
                outputString = this.getMessage("600", this.host);
            }
        }
        this.traceDebug("Handle error response code is: " + response.getStatus());
        this.traceDebug("Handle error response message is: " + response.getErrorMessage());
        this.traceDebug("Handle error exit code is: " + exitCode);
        if (outputString != null) {
            throw new CommandException(outputString, exitCode);
        }
    }

    protected void logError(String messageKey, Object ... arguments) {
        String message = this.getMessage(messageKey, arguments);
        DumpHelper.dumpErrorMessage(message);
    }

    protected void logWarning(String messageKey, Object ... arguments) {
        String message = this.getMessage(messageKey, arguments);
        DumpHelper.dumpWarningMessage(message);
    }

    protected void logInfo(String messageKey, Object ... arguments) {
        String message = this.getMessage(messageKey, arguments);
        DumpHelper.dumpWithNewLine(message);
    }

    protected void logError(String messageKey) {
        String message = this.getMessage(messageKey);
        DumpHelper.dumpErrorMessage(message);
    }

    protected void logWarning(String messageKey) {
        String message = this.getMessage(messageKey);
        DumpHelper.dumpWarningMessage(message);
    }

    protected void logInfo(String messageKey) {
        String message = this.getMessage(messageKey);
        DumpHelper.dumpWithNewLine(message);
    }

    protected void traceDebug(String message) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(message);
        }
    }

    protected void dumpOperation(String operation, Object ... commandSpecificArguments) {
        Object[] defaultArguments = new Object[]{"account", this.getAccount(), "application", this.getApplication(), "component", this.getComponent(), "host", this.host};
        ArrayList<Object> nonNullArguments = new ArrayList<Object>();
        this.addNonNullArguments(nonNullArguments, defaultArguments);
        this.addNonNullArguments(nonNullArguments, commandSpecificArguments);
        DumpHelper.dumpOperationList(this.user, operation, nonNullArguments.toArray(new Object[nonNullArguments.size()]));
        this.traceOperation(operation, nonNullArguments);
    }

    protected void traceOperation(String operation, List<Object> arguments) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(operation);
            for (int i = 0; i < arguments.size(); i += 2) {
                LOGGER.debug(arguments.get(i) + " : " + arguments.get(i + 1));
            }
        }
    }

    private void addNonNullArguments(List<Object> nonNullArguments, Object[] arguments) {
        for (int i = 0; i < arguments.length; i += 2) {
            Object key = arguments[i];
            Object value = arguments[i + 1];
            if (this.nullOrEmpty(arguments[i]) || this.nullOrEmpty(arguments[i + 1])) continue;
            nonNullArguments.add(key);
            nonNullArguments.add(value);
        }
    }

    protected String getMessage(String key, Object ... arguments) {
        CommandMessages messages = CommandMessages.getInstance(this.getMessageGroup());
        return messages.getMessage(key, arguments);
    }

    protected String getMessage(String key) {
        CommandMessages messages = CommandMessages.getInstance(this.getMessageGroup());
        return messages.getMessage(key);
    }

    protected boolean isApplicationLevelOutput() {
        return this.getApplication() != null && this.getComponent() == null;
    }

    protected boolean isComponentLevelOutput() {
        return this.getApplication() != null && this.getComponent() != null;
    }

    protected boolean nullOrEmpty(Object value) {
        return value == null || value.toString().trim().isEmpty();
    }

    protected void validateRequiredParameters(String[][] requiredParameters) {
        ArrayList<String[]> missingParameters = new ArrayList<String[]>();
        for (String[] parameter : requiredParameters) {
            if (parameter[0] != null) continue;
            missingParameters.add(parameter);
        }
        if (!missingParameters.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("The following options are required: ");
            for (int i = 0; i < missingParameters.size(); ++i) {
                String[] parameter = (String[])missingParameters.get(i);
                errorMessage.append(" " + parameter[1] + ", ");
                errorMessage.append(" " + parameter[2] + " , ");
            }
            errorMessage.delete(errorMessage.length() - 3, errorMessage.length());
            throw new HelpException(errorMessage.toString());
        }
    }

    protected static boolean isHanaXsApplication(String application) {
        return application != null && application.indexOf(58) > 0;
    }

    private static String getInstanceName(String application) {
        if (application.indexOf(58) == -1 || application.split(":").length != 2) {
            throw new IllegalArgumentException("Invalid HANA XS Application name, expected format instance-name:application");
        }
        String[] splitted = application.split(":");
        return splitted[0];
    }

    private static String getApplicationName(String application) {
        if (application.indexOf(58) == -1 || application.split(":").length != 2) {
            throw new IllegalArgumentException("Invalid HANA XS Application name, expected format instance-name:application");
        }
        String[] splitted = application.split(":");
        return splitted[1];
    }

    protected static void validateHanaXsApplicationArguments(String application) {
        if (application != null) {
            SACValidator sacValidator = new SACValidator();
            if (AbstractCommand.isHanaXsApplication(application)) {
                String instanceName = AbstractCommand.getInstanceName(application);
                sacValidator.validate("instance-name", instanceName);
            } else {
                sacValidator.validate("application", application);
            }
        }
    }

    protected static CustomChecksInfo getCustomChecksInfo(String account, String application, String component, CustomChecksInfo cci) {
        if (AbstractCommand.isHanaXsApplication(application)) {
            String instanceName = AbstractCommand.getInstanceName(application);
            String applicationName = AbstractCommand.getApplicationName(application);
            cci.setAppliance(instanceName);
            cci.setComponent(applicationName);
        } else {
            cci.setAppliance(application);
            cci.setComponent(component);
        }
        return cci;
    }

    protected static CustomGroupInfo getCustomGroupInfo(String account, String application, String component, CustomGroupInfo cci) {
        if (AbstractCommand.isHanaXsApplication(application)) {
            String instanceName = AbstractCommand.getInstanceName(application);
            String applicationName = AbstractCommand.getApplicationName(application);
            cci.setAppliance(instanceName);
            cci.setComponent(applicationName);
        } else {
            cci.setAppliance(application);
            cci.setComponent(component);
        }
        return cci;
    }
}

