/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.monitoring.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.core.monitoring.cmd.AbstractAlertingCommand;
import com.sap.core.monitoring.cmd.validator.EmailListValidator;
import com.sap.core.monitoring.web.client.MonitoringResponse;
import com.sap.core.monitoring.web.common.CustomGroupInfo;
import com.sap.jpaas.infrastructure.console.exception.CommandException;

@Parameters(commandDescription="Clears configured alert recipients")
public class ClearAlertRecipientsCommand
extends AbstractAlertingCommand {
    private static final String COMMAND_NAME = "clear-alert-recipients";
    private static final String PARAM_RECIPIENTS = "-e";
    private static final String PARAM_RECIPIENTS_LONG = "--email";
    private static final String PARAM_RECIPIENTS_DESCRIPTION = "Comma separated list of recipient emails, clears all if not specified";
    @Parameter(names={"-b", "-application", "--application"}, description="Application name for Java applications or instance-name:application for HANA XS applications.\nInstance name refers to productive or trial SAP HANA instance database name.")
    protected String application;
    @Parameter(names={"-e", "--email"}, description="Comma separated list of recipient emails, clears all if not specified", validateWith=EmailListValidator.class)
    private String emails;

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    void validateArguments() {
        ClearAlertRecipientsCommand.validateHanaXsApplicationArguments(this.application);
        if (ClearAlertRecipientsCommand.isHanaXsApplication(this.application) && this.component != null) {
            String message = this.getMessage("create.invalidarguments");
            throw new ParameterException(message);
        }
    }

    @Override
    protected void executeCommand() throws CommandException {
        this.dumpOperation("Running clear-alert-recipients with the following parameters:", "emails", this.emails);
        this.validateArguments();
        CustomGroupInfo groupInfo = this.createCustomGroupInfo();
        MonitoringResponse<?> response = this.monitoringClient.deleteContactConfiguration(groupInfo);
        if (response.getStatus() == 200) {
            this.logInfo("delete.success");
            this.logInfo("modify.success");
            this.traceDebug("Clear alert recipients finished with code " + response.getStatus());
        } else {
            this.handleErrorResponse(response);
        }
    }

    CustomGroupInfo createCustomGroupInfo() {
        CustomGroupInfo info = new CustomGroupInfo();
        info.setSpace(this.account);
        info = ClearAlertRecipientsCommand.getCustomGroupInfo(this.account, this.application, this.component, info);
        info.setType(this.calculateType());
        info.setContactGroup(this.emails);
        return info;
    }

    @Override
    protected String getMessageGroup() {
        return "recipients";
    }
}

