/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.monitoring.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.NoValidator;
import com.sap.core.monitoring.cmd.AbstractMonitoringCommand;
import com.sap.core.monitoring.cmd.validator.ThresholdValidator;
import com.sap.core.monitoring.cmd.validator.URIValidator;
import com.sap.core.monitoring.web.client.MonitoringResponse;
import com.sap.core.monitoring.web.common.CustomChecksInfo;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.HashMap;

@Parameters(commandDescription="Creates an application availability check")
public class CreateAvailabilityCheckCommand
extends AbstractMonitoringCommand {
    private static final String COMMAND_NAME = "create-availability-check";
    private static final String PARAM_WARNING = "-W";
    private static final String PARAM_WARNING_LONG = "--warning";
    private static final String PARAM_WARNING_DESCRIPTION = "Threshold value or range in seconds, defaults to 50s.";
    private static final String PARAM_CRITICAL = "-C";
    private static final String PARAM_CRITICAL_LONG = "--critical";
    private static final String PARAM_CRITICAL_DESCRIPTION = "Threshold value or range in seconds, defaults to 60s.";
    private static final String PARAM_OVERWRITE = "-w";
    private static final String PARAM_OVERWRITE_LONG = "--overwrite";
    private static final String PARAM_OVERWRITE_DESCRIPTION = "Overwrite existing check (optional)";
    @Parameter(names={"-b", "-application", "--application"}, description="Application name for Java applications or instance-name:application for HANA XS applications.\nInstance name refers to productive or trial SAP HANA instance database name.")
    protected String application;
    @Parameter(names={"-U", "--url"}, description="Absolute or relative application URL", validateWith=URIValidator.class)
    private String url;
    @Parameter(names={"-W", "--warning"}, description="Threshold value or range in seconds, defaults to 50s.", validateWith=ThresholdValidator.class)
    private String warning;
    @Parameter(names={"-C", "--critical"}, description="Threshold value or range in seconds, defaults to 60s.", validateWith=ThresholdValidator.class)
    private String critical;
    @Parameter(names={"-w", "--overwrite"}, description="Overwrite existing check (optional)", validateWith=NoValidator.class)
    private boolean overwrite;

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    public void initWithNoPasswordCheck() {
        super.initWithNoPasswordCheck();
        this.validateRequiredParameters(new String[][]{{this.url, "-U", "--url"}});
    }

    void validateArguments() {
        boolean isAbsolute;
        if (this.component == null && this.application == null && (isAbsolute = this.isAbsolute(this.url))) {
            String message = this.getMessage("create.invalidurl");
            throw new ParameterException(message);
        }
        CreateAvailabilityCheckCommand.validateHanaXsApplicationArguments(this.application);
        if (CreateAvailabilityCheckCommand.isHanaXsApplication(this.application) && this.component != null) {
            String message = this.getMessage("create.invalidarguments");
            throw new ParameterException(message);
        }
    }

    @Override
    protected void executeCommand() throws CommandException {
        this.dumpOperation("Running create-availability-check with the following parameters:", "url", this.url, "warning", this.warning, "critical", this.critical, "overwrite", this.overwrite);
        this.validateArguments();
        CustomChecksInfo cci = this.createCustomChecksInfo();
        if (this.isUpdateOperation()) {
            this.updateAvailabilityCheck(cci);
        } else {
            this.createAvailabilityCheck(cci);
        }
    }

    private boolean isUpdateOperation() {
        return this.overwrite;
    }

    private void createAvailabilityCheck(CustomChecksInfo checkInfo) throws CommandException {
        MonitoringResponse<?> response = this.monitoringClient.addCustomServiceConfiguration(checkInfo);
        int status = response.getStatus();
        if (status == 201) {
            this.logInfo("create.success");
            this.traceDebug("Create availability check operation finished with exit code: " + response.getStatus());
        } else {
            this.handleErrorResponse(response);
        }
    }

    private void updateAvailabilityCheck(CustomChecksInfo checkInfo) throws CommandException {
        MonitoringResponse<?> response = this.monitoringClient.updateCustomServiceConfiguration(checkInfo);
        if (response.getStatus() == 200) {
            this.logInfo("update.success");
            this.traceDebug("Update availability check operation finished with exit code: " + response.getStatus());
        } else {
            this.handleErrorResponse(response);
        }
    }

    protected CustomChecksInfo createCustomChecksInfo() {
        boolean isAbsolute = this.isAbsolute(this.url);
        String template = isAbsolute ? "check-https-service-url-template" : "check-https-service-template";
        HashMap<String, String> customVariables = new HashMap<String, String>();
        String customVariable = isAbsolute ? "_HTTPURL" : "_HTTPURI";
        customVariables.put(customVariable, this.url);
        customVariables.put("_INHERITABLE", "0");
        customVariables.put("_CHECK_TYPE", "APPLICATION AVAILABILITY");
        if (!this.nullOrEmpty(this.warning)) {
            customVariables.put("_HTTPWARNING", this.warning);
        }
        if (!this.nullOrEmpty(this.critical)) {
            customVariables.put("_HTTPCRITICAL", this.critical);
        }
        CustomChecksInfo cci = new CustomChecksInfo();
        cci.setSpace(this.account);
        String runtime = CreateAvailabilityCheckCommand.isHanaXsApplication(this.application) ? "HANAXS" : "JAVA";
        customVariables.put("_HCP_RUNTIME", runtime);
        cci = CreateAvailabilityCheckCommand.getCustomChecksInfo(this.account, this.application, this.component, cci);
        cci.setServiceName("Availability Check");
        cci.setServiceTemplate(template);
        cci.setType(this.calculateType());
        cci.setDefinition(customVariables);
        return cci;
    }

    @Override
    protected String getMessageGroup() {
        return "availability";
    }

    @Override
    protected String getMessageSubGroup() {
        return "availability.create";
    }
}

