/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.monitoring.cmd;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.NoValidator;
import com.sap.core.monitoring.cmd.AbstractMonitoringCommand;
import com.sap.core.monitoring.cmd.validator.MetricNameValidator;
import com.sap.core.monitoring.cmd.validator.ObjectNameValidator;
import com.sap.core.monitoring.web.client.MonitoringResponse;
import com.sap.core.monitoring.web.common.CustomChecksInfo;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.validator.SACValidator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@Parameters(commandDescription="Creates a JMX check and assigns it to a subaccount or application")
public class CreateJMXCheckCommand
extends AbstractMonitoringCommand {
    private static final String COMMAND_NAME = "create-jmx-check";
    private static final String PARAM_NAME = "-n";
    private static final String PARAM_NAME_LONG = "--name";
    private static final String PARAM_NAME_DESCRIPTION = "Name of the JMX check";
    private static final String PARAM_OBJECT_NAME = "-O";
    private static final String PARAM_OBJECT_NAME_LONG = "--object-name";
    private static final String PARAM_OBJECT_NAME_DESCRIPTION = "Object name of the MBean that you want to call";
    private static final String PARAM_ATTRIBUTE = "-A";
    private static final String PARAM_ATTRIBUTE_LONG = "--attribute";
    private static final String PARAM_ATTRIBUTE_DESCRIPTION = "The name of the attribute";
    private static final String PARAM_ATTRIBUTE_KEY = "-K";
    private static final String PARAM_ATTRIBUTE_KEY_LONG = "--key";
    private static final String PARAM_ATTRIBUTE_KEY_DESCRIPTION = "Attribute key, only needed if attribute is a composite data structure (optional)";
    private static final String PARAM_OPERATION = "-o";
    private static final String PARAM_OPERATION_LONG = "--operation";
    private static final String PARAM_OPERATION_DESCRIPTION = "Operation that has to be called on the MBean after checking the attribute value (optional)";
    private static final String PARAM_UNIT = "-U";
    private static final String PARAM_UNIT_LONG = "--unit";
    private static final String PARAM_UNIT_DESCRIPTION = "Unit of measurement (optional)";
    private static final String PARAM_OVERWRITE = "-w";
    private static final String PARAM_OVERWRITE_LONG = "--overwrite";
    private static final String PARAM_OVERWRITE_DESCRIPTION = "Overwrites existing check (optional)";
    private static final String PARAM_WARNING = "-W";
    private static final String PARAM_WARNING_LONG = "--warning";
    private static final String PARAM_WARNING_DESCRIPTION = "Warning threshold (optional) - threshold can be also regular expression/range";
    private static final String PARAM_CRITICAL = "-C";
    private static final String PARAM_CRITICAL_LONG = "--critical";
    private static final String PARAM_CRITICAL_DESCRIPTION = "Critical threshold (optional) - threshold can be also regular expression/range";
    private static final String PARAM_VOLATILE = "-v";
    private static final String PARAM_VOLATILE_LONG = "--volatile";
    private static final String PARAM_VOLATILE_DESCRIPTION = "Allows to specify whether the service is volatile or not";
    @Parameter(names={"-b", "-application", "--application"}, description="Name of the application you want to manage, configure, or deploy", validateWith=SACValidator.class)
    protected String application;
    @Parameter(names={"-n", "--name"}, description="Name of the JMX check", validateWith=MetricNameValidator.class)
    private String name;
    @Parameter(names={"-O", "--object-name"}, description="Object name of the MBean that you want to call", validateWith=ObjectNameValidator.class)
    private String objectName;
    @Parameter(names={"-A", "--attribute"}, description="The name of the attribute", validateWith=NoValidator.class)
    private String attribute;
    @Parameter(names={"-K", "--key"}, description="Attribute key, only needed if attribute is a composite data structure (optional)", validateWith=NoValidator.class)
    private String key;
    @Parameter(names={"-o", "--operation"}, description="Operation that has to be called on the MBean after checking the attribute value (optional)", validateWith=NoValidator.class)
    private String operation;
    @Parameter(names={"-U", "--unit"}, description="Unit of measurement (optional)")
    private String unit;
    @Parameter(names={"-w", "--overwrite"}, description="Overwrites existing check (optional)", validateWith=NoValidator.class)
    private boolean overwrite;
    @Parameter(names={"-W", "--warning"}, description="Warning threshold (optional) - threshold can be also regular expression/range", validateWith=NoValidator.class, converter=EscapeAtConverter.class)
    private String warning;
    @Parameter(names={"-C", "--critical"}, description="Critical threshold (optional) - threshold can be also regular expression/range", validateWith=NoValidator.class, converter=EscapeAtConverter.class)
    private String critical;
    @Parameter(names={"-v", "--volatile"}, description="Allows to specify whether the service is volatile or not", validateWith=NoValidator.class, hidden=true)
    private boolean isVolatile;

    @Override
    public String getApplication() {
        return this.application;
    }

    String getWarning() {
        return this.warning;
    }

    String getCritical() {
        return this.critical;
    }

    @Override
    public void initWithNoPasswordCheck() {
        super.initWithNoPasswordCheck();
        this.validateRequiredParameters(new String[][]{{this.name, PARAM_NAME, PARAM_NAME_LONG}, {this.objectName, PARAM_OBJECT_NAME, PARAM_OBJECT_NAME_LONG}, {this.attribute, PARAM_ATTRIBUTE, PARAM_ATTRIBUTE_LONG}});
    }

    @Override
    protected void executeCommand() throws CommandException {
        this.dumpOperation("Running create-jmx-check with the following parameters:", "name", this.name, "objectName", this.objectName, "attribute", this.attribute, "attributeKey", this.key, "operation", this.operation, "unit", this.unit, "overwrite", this.overwrite, "warning", this.warning, "critical", this.critical, "volatile", this.isVolatile);
        CustomChecksInfo cci = this.createCustomChecksInfo();
        if (this.isUpdateOpeartion()) {
            this.updateJmxCheck(cci);
        } else {
            this.createJmxCheck(cci);
        }
    }

    CustomChecksInfo createCustomChecksInfo() {
        HashMap<String, String> customVariables = new HashMap<String, String>();
        this.setCustomVariables(customVariables);
        this.setVolatileVariables(customVariables);
        CustomChecksInfo cci = new CustomChecksInfo();
        cci.setSpace(this.account);
        cci.setAppliance(this.application);
        cci.setComponent(this.component);
        cci.setServiceTemplate("check-jmx-service-generic-template");
        cci.setServiceName(this.name);
        cci.setType(this.calculateType());
        cci.setDefinition(customVariables);
        return cci;
    }

    private void setCustomVariables(Map<String, String> customVariables) {
        String jmxArguments = this.buildJmxArguments();
        this.setCustomVariable(customVariables, "_JMXARGUMENTS", jmxArguments);
        this.setCustomVariable(customVariables, "_METRIC_NAME", this.name);
        this.setCustomVariable(customVariables, "_JMXOBJECTNAME", this.objectName);
        this.setCustomVariable(customVariables, "_JMXATTRIBUTENAME", this.attribute);
        this.setCustomVariable(customVariables, "_JMXCOMPOUNDKEY", this.key);
        this.setCustomVariable(customVariables, "_METRIC_UNIT", this.unit);
        this.setCustomVariable(customVariables, "_JMXOPERATION", this.operation);
        this.setCustomVariable(customVariables, "_JMXWARNING", this.warning);
        this.setCustomVariable(customVariables, "_JMXCRITICAL", this.critical);
        this.setCustomVariable(customVariables, "_INHERITABLE", "1");
    }

    private void setVolatileVariables(Map<String, String> customVariables) {
        if (!this.isVolatile) {
            return;
        }
        this.setCustomVariable(customVariables, "max_check_attempts", "1");
        this.setCustomVariable(customVariables, "flap_detection_enabled", "0");
        this.setCustomVariable(customVariables, "notification_options", "u,c,w");
        this.setCustomVariable(customVariables, "is_volatile", "1");
    }

    private String buildJmxArguments() {
        StringBuilder builder = new StringBuilder();
        this.setFormattedArg(builder, PARAM_OBJECT_NAME, this.objectName);
        this.setFormattedArg(builder, PARAM_ATTRIBUTE, this.attribute);
        this.setFormattedArg(builder, PARAM_ATTRIBUTE_KEY, this.key);
        this.setFormattedArg(builder, PARAM_OPERATION, this.operation);
        this.setFormattedArg(builder, PARAM_WARNING.toLowerCase(Locale.ENGLISH), this.warning);
        this.setFormattedArg(builder, PARAM_CRITICAL.toLowerCase(Locale.ENGLISH), this.critical);
        return builder.toString();
    }

    private String escape(String value) {
        value = value.replaceAll("\"", "\\\\\"");
        return String.format("'%s'", value);
    }

    private void setFormattedArg(StringBuilder commandLine, String key, String value) {
        if (this.nullOrEmpty(value)) {
            return;
        }
        value = this.escape(value);
        String formattedArg = String.format("%s %s ", key, value);
        commandLine.append(formattedArg);
    }

    private void setCustomVariable(Map<String, String> customVariables, String key, String value) {
        if (this.nullOrEmpty(value)) {
            return;
        }
        customVariables.put(key, value);
    }

    private void createJmxCheck(CustomChecksInfo cci) throws CommandException {
        MonitoringResponse<?> response = this.monitoringClient.addCustomServiceConfiguration(cci);
        int status = response.getStatus();
        if (status == 201) {
            this.logInfo("create.success");
        } else {
            this.handleErrorResponse(response);
        }
        this.traceDebug("Create jmx check operation finished with exit code: " + response.getStatus());
    }

    private void updateJmxCheck(CustomChecksInfo cci) throws CommandException {
        MonitoringResponse<?> response = this.monitoringClient.updateCustomServiceConfiguration(cci);
        if (response.getStatus() == 200) {
            this.logInfo("update.success");
        } else if (response.getStatus() == 404) {
            this.createJmxCheck(cci);
        } else {
            this.handleErrorResponse(response);
        }
        this.traceDebug("Update jmx check operation finished with exit code: " + response.getStatus());
    }

    private boolean isUpdateOpeartion() {
        return this.overwrite;
    }

    @Override
    protected String getMessageGroup() {
        return "jmx";
    }

    @Override
    protected String getMessageSubGroup() {
        return "jmx.create";
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    public static class EscapeAtConverter
    implements IStringConverter<String> {
        @Override
        public String convert(String value) {
            if (value != null && value.startsWith("\\@")) {
                return value.substring(1);
            }
            return value;
        }
    }
}

