/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.monitoring.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.core.monitoring.cmd.AbstractMonitoringCommand;
import com.sap.core.monitoring.web.client.MonitoringResponse;
import com.sap.core.monitoring.web.common.CustomChecksInfo;
import com.sap.jpaas.infrastructure.console.exception.CommandException;

@Parameters(commandDescription="Deletes an application availability check")
public class DeleteAvailabilityCheckCommand
extends AbstractMonitoringCommand {
    private static final String COMMAND_NAME = "delete-availability-check";
    @Parameter(names={"-b", "-application", "--application"}, description="Application name for Java applications or instance-name:application for HANA XS applications.\nInstance name refers to productive or trial SAP HANA instance database name.")
    protected String application;

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    void validateArguments() {
        DeleteAvailabilityCheckCommand.validateHanaXsApplicationArguments(this.application);
        if (DeleteAvailabilityCheckCommand.isHanaXsApplication(this.application) && this.component != null) {
            String message = this.getMessage("create.invalidarguments");
            throw new ParameterException(message);
        }
    }

    @Override
    protected void executeCommand() throws CommandException {
        this.dumpOperation("Running delete-availability-check with the following parameters:", new Object[0]);
        this.validateArguments();
        CustomChecksInfo checkInfo = this.getLandscapeCheckInfo();
        MonitoringResponse<?> response = this.monitoringClient.deleteCustomServiceConfiguration(checkInfo);
        if (response.getStatus() == 200) {
            this.logInfo("delete.success");
            this.traceDebug("Delete availability check opertain with exit code " + response.getStatus());
        } else {
            this.handleErrorResponse(response);
        }
    }

    protected CustomChecksInfo getLandscapeCheckInfo() {
        CustomChecksInfo info = new CustomChecksInfo();
        info.setSpace(this.account);
        info.setType(this.calculateType());
        info = DeleteAvailabilityCheckCommand.getCustomChecksInfo(this.account, this.application, this.component, info);
        info.setServiceName("Availability Check");
        return info;
    }

    @Override
    protected String getMessageGroup() {
        return "availability";
    }

    @Override
    protected String getMessageSubGroup() {
        return "availability.delete";
    }
}

