/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.monitoring.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.NoValidator;
import com.sap.core.monitoring.cmd.AbstractMonitoringCommand;
import com.sap.core.monitoring.web.client.MonitoringResponse;
import com.sap.core.monitoring.web.common.CustomChecksInfo;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.validator.SACValidator;

@Parameters(commandDescription="Deletes the specified JMX check, or all JMX checks")
public class DeleteJMXCheckCommand
extends AbstractMonitoringCommand {
    private static final String COMMAND_NAME = "delete-jmx-check";
    private static final String PARAM_NAME = "-n";
    private static final String PARAM_NAME_LONG = "--name";
    private static final String PARAM_ALL = "-A";
    private static final String PARAM_ALL_LONG = "--all";
    private static final String PARAM_NAME_DESCRIPTION = "Name of the JMX check";
    private static final String PARAM_ALL_DESCRIPTION = "Deletes all JMX checks configured for the given subaccount and application";
    @Parameter(names={"-b", "-application", "--application"}, description="Name of the application you want to manage, configure, or deploy", validateWith=SACValidator.class)
    protected String application;
    @Parameter(names={"-n", "--name"}, description="Name of the JMX check")
    private String name;
    @Parameter(names={"-A", "--all"}, description="Deletes all JMX checks configured for the given subaccount and application", validateWith=NoValidator.class)
    private boolean all = false;

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    protected void executeCommand() throws CommandException {
        this.dumpOperation("Running delete-jmx-check with the following parameters:", "name", this.name, "delete all", this.all);
        if (this.areOptionsInvalid()) {
            throw new HelpException("Invalid command parameters provided, one of --name/-n or --all/-A needs to be specified");
        }
        CustomChecksInfo checkInfo = this.getLandscapeCheckInfo();
        MonitoringResponse<?> response = this.monitoringClient.deleteCustomServiceConfiguration(checkInfo);
        if (response.getStatus() == 200) {
            this.logInfo("delete.success");
            this.traceDebug("Delete JMX check operation with exit code " + response.getStatus());
        } else {
            this.handleErrorResponse(response);
        }
    }

    private boolean areOptionsInvalid() {
        return !this.nullOrEmpty(this.name) && this.all || this.nullOrEmpty(this.name) && !this.all;
    }

    private CustomChecksInfo getLandscapeCheckInfo() {
        CustomChecksInfo info = new CustomChecksInfo();
        info.setSpace(this.account);
        info.setType(this.calculateType());
        info.setAppliance(this.application);
        info.setComponent(this.component);
        info.setServiceTemplate("check-jmx-service-generic-template");
        if (this.all) {
            info.setServiceName(null);
        } else {
            info.setServiceName(this.name);
        }
        return info;
    }

    @Override
    protected String getMessageGroup() {
        return "jmx";
    }

    @Override
    protected String getMessageSubGroup() {
        return "jmx.delete";
    }
}

