/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.monitoring.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.NoValidator;
import com.sap.core.monitoring.cmd.AbstractAlertingCommand;
import com.sap.core.monitoring.web.client.MonitoringBasicAuthClient;
import com.sap.core.monitoring.web.client.MonitoringResponse;
import com.sap.core.monitoring.web.common.CustomGroupInfo;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

@Parameters(commandDescription="Lists configured alert recipients")
public class ListAlertRecipientsCommand
extends AbstractAlertingCommand {
    private static final String COMMAND_NAME = "list-alert-recipients";
    private static final String PARAM_RECURSIVELY = "-R";
    private static final String PARAM_RECURSIVELY_LONG = "--recursively ";
    private static final String HELPER_STRING = "_space_";
    private static final String PARAM_RECURSIVELY_DESCRIPTION = "Lists recipients recursively for the given subaccount and all applications belonging to it";
    @Parameter(names={"-b", "-application", "--application"}, description="Application name for Java applications or instance-name:application for HANA XS applications.\nInstance name refers to productive or trial SAP HANA instance database name.")
    protected String application;
    @Parameter(names={"-R", "--recursively "}, description="Lists recipients recursively for the given subaccount and all applications belonging to it", validateWith=NoValidator.class)
    private boolean recursively;
    private MonitoringResponse<?> response;

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    public String getRecursivelyAlertRecipientsList(CustomGroupInfo[] entities) {
        StringBuffer buffer = new StringBuffer();
        if (entities.length > 0) {
            if (this.isApplicationLevelOutput()) {
                buffer.append("Application-level alert recipients\n");
                this.printApplicationEmailsoOnApplicationLevel(buffer, entities, ListAlertRecipientsCommand.isHanaXsApplication(this.application));
                return buffer.toString();
            }
            if (this.isComponentLevelOutput()) {
                return this.getAlertRecipientsList();
            }
            return this.getAccountOutput(buffer, entities);
        }
        buffer.append("Recipients not set for subaccount " + this.account);
        return buffer.toString();
    }

    @Override
    protected void executeCommand() throws CommandException {
        this.dumpOperation("Running list-alert-recipients with the following parameters:", "recursively", this.recursively);
        this.validateArguments();
        CustomGroupInfo groupInfo = this.createCustomGroupInfo();
        if (this.recursively) {
            this.listAlertRecipientsRecursively(groupInfo);
        } else {
            this.listAlertRecipients(groupInfo);
        }
    }

    @Override
    protected String getMessageGroup() {
        return "recipients";
    }

    @Override
    protected String getMessageSubGroup() {
        return "recipients.list";
    }

    void validateArguments() {
        ListAlertRecipientsCommand.validateHanaXsApplicationArguments(this.application);
        if (ListAlertRecipientsCommand.isHanaXsApplication(this.application) && this.component != null) {
            String message = this.getMessage("create.invalidarguments");
            throw new ParameterException(message);
        }
    }

    void listAlertRecipients(MonitoringBasicAuthClient monitoringClient, CustomGroupInfo groupInfo) {
        this.response = monitoringClient.listContactConfiguration(groupInfo);
        this.checkMonitoringResponse(this.response);
    }

    private void listAlertRecipients(CustomGroupInfo groupInfo) {
        this.response = this.monitoringClient.listContactConfiguration(groupInfo);
        this.checkMonitoringResponse(this.response);
    }

    private void listAlertRecipientsRecursively(CustomGroupInfo groupInfo) {
        this.response = this.monitoringClient.listContactConfigurationRecursively(groupInfo);
        this.checkMonitoringResponse(this.response);
    }

    private void checkMonitoringResponse(MonitoringResponse<?> response) {
        if (response.getStatus() == 200) {
            String recipients = this.recursively ? this.getRecursivelyAlertRecipientsList((CustomGroupInfo[])response.getEntity()) : this.getAlertRecipientsList();
            this.logInfo(recipients);
            this.traceDebug("List alert recipients finished with code " + response.getStatus());
        } else {
            this.handleErrorResponse(response);
        }
    }

    private CustomGroupInfo createCustomGroupInfo() {
        CustomGroupInfo info = new CustomGroupInfo();
        info.setSpace(this.account);
        info = ListAlertRecipientsCommand.getCustomGroupInfo(this.account, this.application, this.component, info);
        info.setType(this.calculateType());
        return info;
    }

    private String getAlertRecipientsList() {
        StringBuffer buffer = new StringBuffer();
        CustomGroupInfo[] entities = (CustomGroupInfo[])this.response.getEntity();
        if (entities.length > 0) {
            buffer.append("Alert recipients: ");
            buffer.append("\n");
            for (CustomGroupInfo groupInfo : entities) {
                buffer.append(groupInfo.getContactGroup());
                buffer.append(",");
            }
            buffer.deleteCharAt(buffer.lastIndexOf(","));
        } else {
            this.printNotSetMessage(buffer);
        }
        return buffer.toString();
    }

    private void printNotSetMessage(StringBuffer buffer) {
        buffer.append("Recipients not set on subaccount level " + this.account);
        if (this.application != null) {
            buffer.append(", application " + this.application);
        }
        if (this.component != null) {
            buffer.append(", component " + this.component);
        }
    }

    private String getAccountOutput(StringBuffer buffer, CustomGroupInfo[] entities) {
        buffer.append("Subaccount-level alert recipients\n");
        ArrayList<CustomGroupInfo> entityInformation = new ArrayList<CustomGroupInfo>();
        for (CustomGroupInfo info : entities) {
            entityInformation.add(info);
        }
        HashMap<String, ArrayList<CustomGroupInfo>> map = this.sortInfoElements(entityInformation, true);
        ArrayList<CustomGroupInfo> spaceInformation = map.get(HELPER_STRING);
        if (spaceInformation != null) {
            this.printSpaceEmails(buffer, spaceInformation, "");
            map.remove(HELPER_STRING);
        } else {
            buffer.append("Recipients not set on subaccount level for subaccount " + this.account + "\n");
        }
        if (map.isEmpty()) {
            buffer.append("Recipients not set on application level for any application of subaccount " + this.account);
            return buffer.toString();
        }
        Iterator<String> set = map.keySet().iterator();
        while (set.hasNext()) {
            ArrayList<CustomGroupInfo> list = map.get(set.next());
            this.printApplicationEmails(buffer, list, false);
        }
        return buffer.toString();
    }

    private void printApplicationEmailsoOnApplicationLevel(StringBuffer buffer, CustomGroupInfo[] entities, boolean isHanaApplication) {
        ArrayList<CustomGroupInfo> applicationInfo = new ArrayList<CustomGroupInfo>();
        for (int i = 0; i < entities.length; ++i) {
            CustomGroupInfo element = entities[i];
            String applianceName = element.getAppliance();
            if (!this.application.equals(applianceName) && !this.canBeXS(element)) continue;
            applicationInfo.add(entities[i]);
        }
        this.printApplicationEmails(buffer, applicationInfo, isHanaApplication);
    }

    private boolean canBeXS(CustomGroupInfo element) {
        String xsApplicationName = element.getAppliance() + ":" + element.getComponent();
        return this.application.equals(xsApplicationName);
    }

    private HashMap<String, ArrayList<CustomGroupInfo>> sortInfoElements(List<CustomGroupInfo> entities, boolean isAapplianceName) {
        HashMap<String, ArrayList<CustomGroupInfo>> map = new HashMap<String, ArrayList<CustomGroupInfo>>();
        for (int i = 0; i < entities.size(); ++i) {
            CustomGroupInfo element = entities.get(i);
            String applianceName = isAapplianceName ? element.getAppliance() : element.getComponent();
            if (applianceName == null) {
                applianceName = HELPER_STRING;
            }
            ArrayList<Object> list = map.containsKey(applianceName) ? map.get(applianceName) : new ArrayList();
            list.add(element);
            map.put(applianceName, list);
        }
        return map;
    }

    private void printApplicationEmails(StringBuffer buffer, List<CustomGroupInfo> customGroupInfo, boolean isHanaApplication) {
        ArrayList<CustomGroupInfo> componentInfo;
        HashMap<String, ArrayList<CustomGroupInfo>> componentMap = this.sortInfoElements(customGroupInfo, false);
        if (!customGroupInfo.isEmpty()) {
            if (!isHanaApplication) {
                buffer.append("\napplication : " + customGroupInfo.get(0).getAppliance() + "\n");
            } else {
                buffer.append("\nHANA XS instance : " + customGroupInfo.get(0).getAppliance() + "\n");
            }
        }
        if ((componentInfo = componentMap.get(HELPER_STRING)) != null) {
            this.printEmails(buffer, componentInfo, "\t");
            componentMap.remove(HELPER_STRING);
        }
        Iterator<String> set = componentMap.keySet().iterator();
        buffer.append("\n");
        while (set.hasNext()) {
            String copmonentName = set.next();
            ArrayList<CustomGroupInfo> component = componentMap.get(copmonentName);
            if (!isHanaApplication) {
                buffer.append("\tcomponent : " + copmonentName + "\n");
            } else {
                buffer.append("\tHANA XS application : " + copmonentName + "\n");
            }
            this.printEmails(buffer, component, "\t\t");
        }
    }

    private void printSpaceEmails(StringBuffer buffer, List<CustomGroupInfo> spaceEmails, String offset) {
        buffer.append("account: " + this.account + "\n");
        this.printEmails(buffer, spaceEmails, "");
    }

    private void printEmails(StringBuffer buffer, List<CustomGroupInfo> emails, String offset) {
        buffer.append(offset);
        for (CustomGroupInfo groupInfo : emails) {
            buffer.append(groupInfo.getContactGroup());
            buffer.append(",");
        }
        if (buffer.indexOf(",") > 0) {
            buffer.deleteCharAt(buffer.lastIndexOf(","));
        }
        buffer.append("\n");
    }
}

