/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.monitoring.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.NoValidator;
import com.sap.core.monitoring.cmd.AbstractMonitoringCommand;
import com.sap.core.monitoring.web.client.MonitoringResponse;
import com.sap.core.monitoring.web.common.CustomChecksInfo;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Parameters(commandDescription="Lists configured availability checks")
public class ListAvailabilityCheckCommand
extends AbstractMonitoringCommand {
    private static final String COMMAND_NAME = "list-availability-check";
    private static final String PARAM_RECURSIVELY = "-R";
    private static final String PARAM_RECURSIVELY_LONG = "--recursively ";
    private static final String PARAM_RECURSIVELY_DESCRIPTION = "Lists availability checks recursively for the given subaccount and all applications belonging to it";
    private static final String HELPER_STRING = "_space_";
    private static final String TWO_SPACES = "  ";
    @Parameter(names={"-R", "--recursively "}, description="Lists availability checks recursively for the given subaccount and all applications belonging to it", validateWith=NoValidator.class)
    private boolean recursively;
    @Parameter(names={"-b", "-application", "--application"}, description="Application name for Java applications or instance-name:application for HANA XS applications.\nInstance name refers to productive or trial SAP HANA instance database name.")
    protected String application;
    private MonitoringResponse<CustomChecksInfo[]> response;

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    protected String getMessageGroup() {
        return "availability";
    }

    @Override
    protected void executeCommand() throws CommandException {
        this.dumpOperation("Running list-availability-checks with the following parameters:", "recursively", this.recursively);
        this.validateArguments();
        CustomChecksInfo customChecksInfo = this.createCustomChecksInfo();
        this.response = this.recursively ? this.monitoringClient.listCustomServiceConfigurationRecursively(customChecksInfo) : this.monitoringClient.listCustomServiceConfiguration(customChecksInfo);
        if (this.response.getStatus() == 200) {
            String javaChecksOutput = null;
            String hanaXsChecksOutput = null;
            CustomChecksInfo[] customChecksInfos = this.response.getEntity();
            CustomChecksInfo[] hanaXsCustomChecksInfos = this.getHanaXsCustomChecksInfo(customChecksInfos);
            CustomChecksInfo[] javaCustomChecksInfos = this.getJavaCustomChecksInfo(customChecksInfos);
            if (this.recursively) {
                StringBuilder hanaxsBuilder = new StringBuilder();
                hanaXsChecksOutput = this.getHanaXsChecksOutputRecursively(hanaXsCustomChecksInfos, hanaxsBuilder);
                StringBuilder javaBuilder = new StringBuilder();
                javaChecksOutput = this.getAvailabilityChecksOutputRecursively(javaCustomChecksInfos, javaBuilder);
            } else {
                hanaXsChecksOutput = this.getHanaXsChecksOutput(hanaXsCustomChecksInfos);
                javaChecksOutput = this.getJavaChecksOutput(javaCustomChecksInfos);
            }
            if (!hanaXsChecksOutput.isEmpty()) {
                this.logInfo(hanaXsChecksOutput);
            }
            if (!javaChecksOutput.isEmpty()) {
                this.logInfo(javaChecksOutput);
            }
            this.traceDebug("List availability checks finished with code " + this.response.getStatus());
        } else {
            this.handleErrorResponse(this.response);
        }
    }

    public String getAvailabilityChecksOutputRecursively(CustomChecksInfo[] customChecksInfos, StringBuilder builder) {
        builder.append("Java Applications\n\n");
        if (customChecksInfos.length > 0) {
            if (this.isApplicationLevelOutput()) {
                return this.getApplicationLevelOutput(customChecksInfos, builder);
            }
            if (this.isComponentLevelOutput()) {
                return this.getComponentLevelOutput(customChecksInfos, builder);
            }
            return this.getAccountLevelOutput(customChecksInfos, builder);
        }
        this.printlnAccountLevelAvailabilityCheck(builder, TWO_SPACES);
        this.printNoAvailabilityCheckSetForAccount(builder, "\t");
        return builder.toString();
    }

    public String getHanaXsChecksOutputRecursively(CustomChecksInfo[] customChecksInfos, StringBuilder builder) {
        builder.append("HANA XS Applications\n\n");
        if (customChecksInfos.length > 0) {
            Map<String, List<CustomChecksInfo>> sortedCustomChecks = this.sortCustomChecks(customChecksInfos);
            Iterator<String> iterator = sortedCustomChecks.keySet().iterator();
            while (iterator.hasNext()) {
                List<CustomChecksInfo> list = sortedCustomChecks.get(iterator.next());
                this.printHanaXsDefinitions(list, builder);
            }
        } else {
            this.printlnNoAvailabilityChecksSetForHanaXsApplications(builder, "\t");
        }
        return builder.toString();
    }

    public String getHanaXsChecksOutput(CustomChecksInfo[] customChecksInfos) {
        StringBuilder builder = new StringBuilder();
        builder.append("HANA XS Applications\n\n");
        if (customChecksInfos.length > 0) {
            for (CustomChecksInfo customChecksInfo : customChecksInfos) {
                this.printHanaXsDefinition(customChecksInfo, builder, "\t");
            }
        } else if (ListAvailabilityCheckCommand.isHanaXsApplication(this.application)) {
            this.printlnNoAvailabilityChecksSetForHanaXsApplications(builder, "\t");
        }
        return builder.toString();
    }

    public String getComponentLevelOutput(CustomChecksInfo[] customChecksInfos, StringBuilder builder) {
        if (customChecksInfos.length > 0) {
            this.printlnAccountApplicationComponent(builder, "\t");
            this.printJavaDefinitions(Arrays.asList(customChecksInfos), builder, "\t");
        } else {
            this.printNoAvailabilityCheckSetForAccount(builder, "\t");
        }
        return builder.toString();
    }

    private String getJavaChecksOutput(CustomChecksInfo[] customChecksInfos) {
        StringBuilder builder = new StringBuilder();
        builder.append("Java Applications\n\n");
        if (customChecksInfos.length > 0) {
            this.printlnAccountApplicationComponent(builder, "\t");
            this.printJavaDefinitions(Arrays.asList(customChecksInfos), builder, "\t");
        } else {
            this.printlnNoAvailabilityChecksSetForJavaApplications(builder, "\t");
        }
        return builder.toString();
    }

    private CustomChecksInfo[] getJavaCustomChecksInfo(CustomChecksInfo[] customChecksInfos) {
        ArrayList<CustomChecksInfo> javaCustomChecksInfo = new ArrayList<CustomChecksInfo>();
        for (CustomChecksInfo customChecksInfo : customChecksInfos) {
            String hcpRuntime = customChecksInfo.getDefinition().get("_HCP_RUNTIME");
            if (hcpRuntime != null && !hcpRuntime.equals("JAVA")) continue;
            javaCustomChecksInfo.add(customChecksInfo);
        }
        return javaCustomChecksInfo.toArray(new CustomChecksInfo[javaCustomChecksInfo.size()]);
    }

    private CustomChecksInfo[] getHanaXsCustomChecksInfo(CustomChecksInfo[] customChecksInfos) {
        ArrayList<CustomChecksInfo> hanaxsCustomChecksInfo = new ArrayList<CustomChecksInfo>();
        for (CustomChecksInfo customChecksInfo : customChecksInfos) {
            String hcpRuntime = customChecksInfo.getDefinition().get("_HCP_RUNTIME");
            if (hcpRuntime == null || !hcpRuntime.equals("HANAXS")) continue;
            hanaxsCustomChecksInfo.add(customChecksInfo);
        }
        return hanaxsCustomChecksInfo.toArray(new CustomChecksInfo[hanaxsCustomChecksInfo.size()]);
    }

    private CustomChecksInfo createCustomChecksInfo() {
        CustomChecksInfo cci = new CustomChecksInfo();
        cci.setSpace(this.account);
        cci = ListAvailabilityCheckCommand.getCustomChecksInfo(this.account, this.application, this.component, cci);
        cci.setType(this.calculateType());
        cci.setServiceName("Availability Check");
        return cci;
    }

    private String getAccountLevelOutput(CustomChecksInfo[] customChecksInfos, StringBuilder builder) {
        this.printlnAccountLevelAvailabilityCheck(builder, TWO_SPACES);
        Map<String, List<CustomChecksInfo>> customChecksInfoSortedMap = this.sortCustomChecks(customChecksInfos);
        List<CustomChecksInfo> spaceInformation = customChecksInfoSortedMap.get(HELPER_STRING);
        if (spaceInformation != null) {
            builder.append("\taccount     : " + this.account + "\n");
            this.printlnJavaDefinitions(spaceInformation, builder, "\t");
            customChecksInfoSortedMap.remove(HELPER_STRING);
        } else {
            builder.append("\tNo availability check set on subaccount level for subaccount " + this.account + "\n\n");
        }
        if (customChecksInfoSortedMap.isEmpty()) {
            builder.append("  Application-level availability checks\n\n");
            builder.append("\tNo availability checks set on application level for any application of subaccount " + this.account);
            return builder.toString();
        }
        builder.append("  Application-level availability checks\n");
        Iterator<String> set = customChecksInfoSortedMap.keySet().iterator();
        while (set.hasNext()) {
            List<CustomChecksInfo> list = customChecksInfoSortedMap.get(set.next());
            this.printCustomChecksInfosOnApplicationLevel(list, builder);
        }
        return builder.toString();
    }

    private String getApplicationLevelOutput(CustomChecksInfo[] customChecksInfos, StringBuilder builder) {
        builder.append("  Application-level availability checks\n\n");
        this.printCustomChecksInfosOnApplicationLevel(customChecksInfos, builder);
        return builder.toString();
    }

    private void printCustomChecksInfosOnApplicationLevel(CustomChecksInfo[] customChecksInfos, StringBuilder builder) {
        ArrayList<CustomChecksInfo> customChecksInfosOnApplicationLevel = new ArrayList<CustomChecksInfo>();
        for (int i = 0; i < customChecksInfos.length; ++i) {
            CustomChecksInfo customChecksInfo = customChecksInfos[i];
            String appliance = customChecksInfo.getAppliance();
            if (!this.application.equals(appliance)) continue;
            customChecksInfosOnApplicationLevel.add(customChecksInfos[i]);
        }
        this.printCustomChecksInfosOnApplicationLevel(customChecksInfosOnApplicationLevel, builder);
    }

    private void printCustomChecksInfosOnApplicationLevel(List<CustomChecksInfo> customChecksInfosOnApplicationLevel, StringBuilder builder) {
        Map<String, List<CustomChecksInfo>> sortedCustomChecksOnApplicationLevel = this.sortCustomChecksOnApplicationLevel(customChecksInfosOnApplicationLevel);
        builder.append("\n\tapplication : " + customChecksInfosOnApplicationLevel.get(0).getAppliance() + "\n");
        List<CustomChecksInfo> customChecksOnApplicationLevel = sortedCustomChecksOnApplicationLevel.get(HELPER_STRING);
        if (customChecksOnApplicationLevel != null) {
            this.printJavaDefinitions(customChecksOnApplicationLevel, builder, "\t");
            sortedCustomChecksOnApplicationLevel.remove(HELPER_STRING);
        }
        for (String copmonentName : sortedCustomChecksOnApplicationLevel.keySet()) {
            List<CustomChecksInfo> customChecksInfos = sortedCustomChecksOnApplicationLevel.get(copmonentName);
            builder.append("\n\t\tcomponent   : " + copmonentName + "\n");
            this.printJavaDefinitions(customChecksInfos, builder, "\t\t");
        }
    }

    private void printHanaXsDefinitions(List<CustomChecksInfo> customChecksInfos, StringBuilder builder) {
        for (int i = 0; i < customChecksInfos.size(); ++i) {
            this.printHanaXsDefinition(customChecksInfos.get(i), builder, "\t");
            if (i == customChecksInfos.size() - 1) continue;
            builder.append("\n");
        }
    }

    private void printHanaXsDefinition(CustomChecksInfo customChecksInfo, StringBuilder builder, String offset) {
        String hanaXsApplicationName = this.getHanaXsApplicationName(customChecksInfo);
        builder.append(offset + "application : ");
        builder.append(hanaXsApplicationName);
        builder.append("\n");
        Map<String, String> definition = customChecksInfo.getDefinition();
        String value = definition.get("_HTTPURL");
        if (value != null && !value.equals("NULL")) {
            builder.append(offset + "url         : ");
            builder.append(value);
            builder.append("\n");
        } else {
            builder.append(offset + "url         : ");
            builder.append(definition.get("_HTTPURI"));
            builder.append("\n");
        }
        builder.append(offset + "warning     : ");
        builder.append(definition.get("_HTTPWARNING"));
        builder.append(" s");
        builder.append("\n");
        builder.append(offset + "critical    : ");
        builder.append(definition.get("_HTTPCRITICAL"));
        builder.append(" s");
        builder.append("\n");
        builder.append(offset + "technology  : ");
        builder.append("HANA XS");
        builder.append("\n");
    }

    private String getHanaXsApplicationName(CustomChecksInfo customChecksInfo) {
        return customChecksInfo.getAppliance() + ":" + customChecksInfo.getComponent();
    }

    private void printlnJavaDefinitions(List<CustomChecksInfo> customChecksInfos, StringBuilder builder, String offset) {
        this.printJavaDefinitions(customChecksInfos, builder, offset);
        builder.append("\n");
    }

    private void printJavaDefinitions(List<CustomChecksInfo> customChecksInfos, StringBuilder builder, String offset) {
        for (CustomChecksInfo customChecksInfo : customChecksInfos) {
            Map<String, String> definition = customChecksInfo.getDefinition();
            String value = definition.get("_HTTPURL");
            if (value != null && !value.equals("NULL")) {
                builder.append(offset + "url         : ");
                builder.append(value);
                builder.append(offset + "\n");
            } else {
                builder.append(offset + "url         : ");
                builder.append(definition.get("_HTTPURI"));
                builder.append("\n");
            }
            builder.append(offset + "warning     : ");
            builder.append(definition.get("_HTTPWARNING"));
            builder.append(" s");
            builder.append("\n");
            builder.append(offset + "critical    : ");
            builder.append(definition.get("_HTTPCRITICAL"));
            builder.append(" s");
            builder.append("\n");
            builder.append(offset + "technology  : ");
            builder.append("Java");
            builder.append("\n");
        }
    }

    private Map<String, List<CustomChecksInfo>> sortCustomChecks(CustomChecksInfo[] customChecksInfos) {
        HashMap<String, List<CustomChecksInfo>> customChecksInfosSortedMap = new HashMap<String, List<CustomChecksInfo>>();
        for (int i = 0; i < customChecksInfos.length; ++i) {
            CustomChecksInfo customChecksInfo = customChecksInfos[i];
            String appliance = customChecksInfo.getAppliance();
            if (appliance == null) {
                appliance = HELPER_STRING;
            }
            List list = customChecksInfosSortedMap.containsKey(appliance) ? (List)customChecksInfosSortedMap.get(appliance) : new ArrayList();
            list.add(customChecksInfo);
            customChecksInfosSortedMap.put(appliance, list);
        }
        return customChecksInfosSortedMap;
    }

    private Map<String, List<CustomChecksInfo>> sortCustomChecksOnApplicationLevel(List<CustomChecksInfo> customChecksInfos) {
        HashMap<String, List<CustomChecksInfo>> map = new HashMap<String, List<CustomChecksInfo>>();
        for (CustomChecksInfo customChecksInfo : customChecksInfos) {
            CustomChecksInfo cci = customChecksInfo;
            String componentName = cci.getComponent();
            if (componentName == null) {
                componentName = HELPER_STRING;
            }
            List list = map.containsKey(componentName) ? (List)map.get(componentName) : new ArrayList();
            list.add(cci);
            map.put(componentName, list);
        }
        return map;
    }

    private void printNoAvailabilityCheckSetForAccount(StringBuilder builder, String offset) {
        builder.append(offset + "No availability check set for subaccount " + this.account);
        if (this.application != null) {
            builder.append(", application " + this.application);
        }
        if (this.component != null) {
            builder.append(", component " + this.component);
        }
    }

    private void printlnAccountLevelAvailabilityCheck(StringBuilder builder, String offset) {
        builder.append(offset + "Subaccount-level availability check" + "\n\n");
    }

    private void printlnNoAvailabilityChecksSetForHanaXsApplications(StringBuilder builder, String offset) {
        builder.append(offset + "No availability checks set for HANA XS Applications" + "\n");
    }

    private void printlnNoAvailabilityChecksSetForJavaApplications(StringBuilder builder, String offset) {
        builder.append(offset + "No availability checks set for Java Applications" + "\n");
    }

    private void printlnAccountApplicationComponent(StringBuilder builder, String offset) {
        builder.append(offset + "account     : " + this.account);
        if (this.application != null) {
            builder.append("\n" + offset + "application : " + this.application);
        }
        if (this.component != null) {
            builder.append("\n" + offset + "component   : " + this.component);
        }
        builder.append("\n");
    }

    private void validateArguments() {
        ListAvailabilityCheckCommand.validateHanaXsApplicationArguments(this.application);
        if (ListAvailabilityCheckCommand.isHanaXsApplication(this.application) && this.component != null) {
            String message = this.getMessage("create.invalidarguments");
            throw new ParameterException(message);
        }
    }
}

