/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.monitoring.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.NoValidator;
import com.sap.core.monitoring.cmd.AbstractMonitoringCommand;
import com.sap.core.monitoring.web.client.MonitoringResponse;
import com.sap.core.monitoring.web.common.CustomChecksInfo;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.validator.SACValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@Parameters(commandDescription="Lists the configured JMX checks per subaccount/application")
public class ListJMXCheckCommand
extends AbstractMonitoringCommand {
    private static final String COMMAND_NAME = "list-jmx-checks";
    private static final String PARAM_RECURSIVELY = "-R";
    private static final String PARAM_RECURSIVELY_LONG = "--recursively ";
    private static final String PARAM_RECURSIVELY_DESCRIPTION = "Starts at a specified level (subaccount/application/component) and shows all configurations below that level including the level";
    @Parameter(names={"-b", "-application", "--application"}, description="Name of the application you want to manage, configure, or deploy", validateWith=SACValidator.class)
    protected String application;
    @Parameter(names={"-R", "--recursively "}, description="Starts at a specified level (subaccount/application/component) and shows all configurations below that level including the level", validateWith=NoValidator.class)
    private boolean recursively = false;
    private MonitoringResponse<CustomChecksInfo[]> response;
    private String helperString = "_space_";

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    protected void executeCommand() throws CommandException {
        this.dumpOperation("Running list-jmx-check with the following parameters:", "recursively", this.recursively);
        CustomChecksInfo checksInfo = this.createCustomChecksInfo();
        this.response = this.recursively ? this.monitoringClient.listCustomServiceConfigurationRecursively(checksInfo) : this.monitoringClient.listCustomServiceConfiguration(checksInfo);
        if (this.response.getStatus() == 200) {
            String checks = this.recursively ? this.getJmxChecksListRecursively(this.response.getEntity()) : this.getComponentLevelOutput();
            this.logInfo(checks);
            this.traceDebug("list-jmx-check finished with code " + this.response.getStatus());
        } else {
            this.handleErrorResponse(this.response);
        }
    }

    private CustomChecksInfo createCustomChecksInfo() {
        CustomChecksInfo info = new CustomChecksInfo();
        info.setSpace(this.account);
        info.setAppliance(this.application);
        info.setComponent(this.component);
        info.setServiceTemplate("check-jmx-service-generic-template");
        info.setType(this.calculateType());
        return info;
    }

    private String getComponentLevelOutput() {
        StringBuffer buffer = new StringBuffer();
        CustomChecksInfo[] entities = this.response.getEntity();
        if (entities != null && entities.length > 0) {
            this.printInputParamerts(buffer);
            ArrayList<CustomChecksInfo> info = new ArrayList<CustomChecksInfo>();
            for (int i = 0; i < entities.length; ++i) {
                info.add(entities[i]);
            }
            this.printDefinitions(buffer, info, "");
        } else {
            this.printNotSetMessage(buffer);
        }
        return buffer.toString();
    }

    public String getJmxChecksListRecursively(CustomChecksInfo[] entities) {
        StringBuffer buffer = new StringBuffer();
        if (entities.length > 0) {
            if (this.isApplicationLevelOutput()) {
                return this.getApplicationLevelOutput(buffer, entities);
            }
            if (this.isComponentLevelOutput()) {
                return this.getComponentLevelOutput();
            }
            return this.getAccountLevelOutput(entities, buffer);
        }
        this.printNotSetMessage(buffer);
        return buffer.toString();
    }

    private String getAccountLevelOutput(CustomChecksInfo[] entities, StringBuffer buffer) {
        buffer.append("Subaccount-level JMX checks\n\n");
        HashMap<String, ArrayList<CustomChecksInfo>> map = this.sortInfoElements(entities);
        ArrayList<CustomChecksInfo> spaceInformation = map.get(this.helperString);
        if (spaceInformation != null) {
            buffer.append("account       : " + this.account + "\n\n");
            this.printDefinitions(buffer, spaceInformation, "");
            map.remove(this.helperString);
        } else {
            buffer.append("JMX check not set on subaccount level for subaccount " + this.account + "\n");
        }
        if (map.isEmpty()) {
            buffer.append("JMX checks not set on application level for any application of subaccount " + this.account);
            return buffer.toString();
        }
        Iterator<String> set = map.keySet().iterator();
        buffer.append("\nApplication JMX checks \n\n");
        while (set.hasNext()) {
            ArrayList<CustomChecksInfo> list = map.get(set.next());
            this.printAppliances(buffer, list);
        }
        return buffer.toString();
    }

    private String getApplicationLevelOutput(StringBuffer buffer, CustomChecksInfo[] entities) {
        buffer.append("Application-level JMX check\n\n");
        this.printApplicationCheksOnApplicationLevel(buffer, entities);
        return buffer.toString();
    }

    private void printApplicationCheksOnApplicationLevel(StringBuffer buffer, CustomChecksInfo[] entities) {
        ArrayList<CustomChecksInfo> applicationInfo = new ArrayList<CustomChecksInfo>();
        for (int i = 0; i < entities.length; ++i) {
            CustomChecksInfo element = entities[i];
            String applianceName = element.getAppliance();
            if (!this.application.equals(applianceName)) continue;
            applicationInfo.add(entities[i]);
        }
        this.printAppliances(buffer, applicationInfo);
    }

    private void printAppliances(StringBuffer buffer, ArrayList<CustomChecksInfo> list) {
        HashMap<String, ArrayList<CustomChecksInfo>> componentMap = this.sortComponentElements(list);
        buffer.append("\n\tapplication   : " + list.get(0).getAppliance() + "\n\n");
        ArrayList<CustomChecksInfo> componentInfo = componentMap.get(this.helperString);
        if (componentInfo != null) {
            this.printDefinitions(buffer, componentInfo, "\t");
            componentMap.remove(this.helperString);
        }
        for (String copmonentName : componentMap.keySet()) {
            ArrayList<CustomChecksInfo> component = componentMap.get(copmonentName);
            buffer.append("\n\t\tcomponent     : " + copmonentName + "\n\n");
            this.printDefinitions(buffer, component, "\t\t");
        }
    }

    private void printDefinitions(StringBuffer buffer, ArrayList<CustomChecksInfo> spaceInformation, String offset) {
        for (CustomChecksInfo checksInfo : spaceInformation) {
            Map<String, String> def = checksInfo.getDefinition();
            this.printNotNullArgument(buffer, offset, "check-name    : ", checksInfo.getServiceName());
            this.printNotNullArgument(buffer, offset, "object-name   : ", def.get("_JMXOBJECTNAME"));
            this.printNotNullArgument(buffer, offset, "attribute     : ", def.get("_JMXATTRIBUTENAME"));
            this.printNotNullArgument(buffer, offset, "attribute key : ", def.get("_JMXCOMPOUNDKEY"));
            this.printNotNullArgument(buffer, offset, "warning       : ", def.get("_JMXWARNING"));
            this.printNotNullArgument(buffer, offset, "critical      : ", def.get("_JMXCRITICAL"));
            this.printNotNullArgument(buffer, offset, "operation     : ", def.get("_JMXOPERATION"));
            this.printNotNullArgument(buffer, offset, "unit          : ", def.get("_METRIC_UNIT"));
            buffer.append("\n");
        }
    }

    private void printNotNullArgument(StringBuffer output, String offset, String key, String value) {
        if (value == null) {
            return;
        }
        output.append(offset + key);
        output.append(value);
        output.append("\n");
    }

    private HashMap<String, ArrayList<CustomChecksInfo>> sortInfoElements(CustomChecksInfo[] entities) {
        HashMap<String, ArrayList<CustomChecksInfo>> map = new HashMap<String, ArrayList<CustomChecksInfo>>();
        for (int i = 0; i < entities.length; ++i) {
            CustomChecksInfo element = entities[i];
            String applianceName = element.getAppliance();
            if (applianceName == null) {
                applianceName = this.helperString;
            }
            ArrayList<Object> list = map.containsKey(applianceName) ? map.get(applianceName) : new ArrayList();
            list.add(element);
            map.put(applianceName, list);
        }
        return map;
    }

    private HashMap<String, ArrayList<CustomChecksInfo>> sortComponentElements(ArrayList<CustomChecksInfo> entities) {
        HashMap<String, ArrayList<CustomChecksInfo>> map = new HashMap<String, ArrayList<CustomChecksInfo>>();
        for (CustomChecksInfo checkInfo : entities) {
            CustomChecksInfo element = checkInfo;
            String componentName = element.getComponent();
            if (componentName == null) {
                componentName = this.helperString;
            }
            ArrayList<Object> list = map.containsKey(componentName) ? map.get(componentName) : new ArrayList();
            list.add(element);
            map.put(componentName, list);
        }
        return map;
    }

    private void printNotSetMessage(StringBuffer buffer) {
        buffer.append("JMX checks not set for subaccount " + this.account);
        if (this.application != null) {
            buffer.append(", application " + this.application);
        }
        if (this.component != null) {
            buffer.append(", component " + this.component);
        }
        buffer.append("\n\n");
    }

    private void printInputParamerts(StringBuffer buffer) {
        buffer.append("account       : " + this.account);
        if (this.application != null) {
            buffer.append("\napplication   : " + this.application);
        }
        if (this.component != null) {
            buffer.append("\ncomponent     : " + this.component);
        }
        buffer.append("\n\n");
    }

    @Override
    protected String getMessageGroup() {
        return "jmx";
    }
}

