/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.monitoring.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.NoValidator;
import com.sap.core.monitoring.cmd.AbstractAlertingCommand;
import com.sap.core.monitoring.cmd.validator.EmailListValidator;
import com.sap.core.monitoring.web.client.MonitoringBasicAuthClient;
import com.sap.core.monitoring.web.client.MonitoringResponse;
import com.sap.core.monitoring.web.common.CustomGroupInfo;
import com.sap.jpaas.infrastructure.console.exception.CommandException;

@Parameters(commandDescription="Sets alert recipients")
public class SetAlertRecipientsCommand
extends AbstractAlertingCommand {
    private static final String PARAM_RECIPIENTS = "-e";
    private static final String PARAM_RECIPIENTS_LONG = "--email";
    private static final String PARAM_RECIPIENTS_DESCRIPTION = "Comma separated list of recipient emails";
    private static final String COMMAND_NAME = "set-alert-recipients";
    private static final String PARAM_OVEWRITE = "--overwrite";
    private static final String PARAM_OVERWRITE_LONG = "-w";
    private static final String PARAM_OVERWRITE_DESCRIPTION = "Overwrite existing recipients (optional)";
    @Parameter(names={"-e", "--email"}, description="Comma separated list of recipient emails", validateWith=EmailListValidator.class)
    private String emails;
    @Parameter(names={"--overwrite", "-w"}, description="Overwrite existing recipients (optional)", validateWith=NoValidator.class)
    private boolean overwrite;
    @Parameter(names={"-b", "-application", "--application"}, description="Application name for Java applications or instance-name:application for HANA XS applications.\nInstance name refers to productive or trial SAP HANA instance database name.")
    protected String application;

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    public void initWithNoPasswordCheck() {
        super.initWithNoPasswordCheck();
        this.validateRequiredParameters(new String[][]{{this.emails, PARAM_RECIPIENTS, PARAM_RECIPIENTS_LONG}});
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    protected void executeCommand() throws CommandException {
        this.dumpOperation("Running set-alert-recipients with the following parameters:", "emails", this.emails, "overwrite", this.overwrite);
        this.validateArguments();
        CustomGroupInfo groupInfo = this.createCustomGroupInfo();
        if (this.overwrite) {
            this.updateAlertRecipients(groupInfo);
        } else {
            this.setAlertRecipients(groupInfo);
        }
    }

    @Override
    protected String getMessageGroup() {
        return "recipients";
    }

    @Override
    protected String getMessageSubGroup() {
        return "recipients.set";
    }

    protected CustomGroupInfo createCustomGroupInfo() {
        CustomGroupInfo info = new CustomGroupInfo();
        info.setSpace(this.account);
        info = SetAlertRecipientsCommand.getCustomGroupInfo(this.account, this.application, this.component, info);
        info.setContactGroup(this.emails);
        info.setType(this.calculateType());
        return info;
    }

    void validateArguments() {
        SetAlertRecipientsCommand.validateHanaXsApplicationArguments(this.application);
        if (SetAlertRecipientsCommand.isHanaXsApplication(this.application) && this.component != null) {
            String message = this.getMessage("create.invalidarguments");
            throw new ParameterException(message);
        }
    }

    void setAlertRecipients(MonitoringBasicAuthClient monitoringClient, CustomGroupInfo groupInfo) throws CommandException {
        MonitoringResponse<?> response = monitoringClient.addContactConfiguration(groupInfo);
        if (response.getStatus() == 201) {
            this.logInfo("create.success");
            this.logInfo("modify.success");
            this.traceDebug("Set alert recipients finished with exit code: " + response.getStatus());
        } else {
            this.handleErrorResponse(response);
        }
    }

    private void updateAlertRecipients(CustomGroupInfo groupInfo) throws CommandException {
        MonitoringResponse<?> response = this.monitoringClient.updateContactConfiguration(groupInfo);
        if (response.getStatus() == 200) {
            this.logInfo("update.success");
            this.logInfo("modify.success");
            this.traceDebug("Update alert recipients finished with exit code: " + response.getStatus());
        } else {
            this.handleErrorResponse(response);
        }
    }

    private void setAlertRecipients(CustomGroupInfo groupInfo) throws CommandException {
        MonitoringResponse<?> response = this.monitoringClient.addContactConfiguration(groupInfo);
        if (response.getStatus() == 201) {
            this.logInfo("create.success");
            this.logInfo("modify.success");
            this.traceDebug("Set alert recipients finished with exit code: " + response.getStatus());
        } else {
            this.handleErrorResponse(response);
        }
    }
}

