/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.monitoring.cmd.message;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CommandMessages {
    private static final String RESOURCE_BUNDLE_NAME = "com.sap.core.monitoring.cmd.message.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.sap.core.monitoring.cmd.message.messages");
    public static final String KEY_UPDATE_SUCCESS = "update.success";
    public static final String KEY_CREATE_SUCCESS = "create.success";
    public static final String KEY_DELETE_SUCCESS = "delete.success";
    public static final String KEY_MODIFY_SUCCESS = "modify.success";
    public static final String KEY_CREATE_INVALIDURL = "create.invalidurl";
    public static final String KEY_CREATE_INVALID_ARGUMENTS = "create.invalidarguments";
    public static final String KEY_DELETE_INVALID_ARGUMENTS = "delete.invalidarguments";
    public static final String KEY_BAD_REQUEST = "400";
    public static final String KEY_UNAUTHORIZED = "401";
    public static final String KEY_FORBIDDEN = "403";
    public static final String KEY_NOT_FOUND = "404";
    public static final String KEY_ACCOUNT_NOT_FOUND = "404a";
    public static final String KEY_APPLICATION_NOT_FOUND = "404b";
    public static final String KEY_COMPONENT_NOT_FOUND = "404c";
    public static final String KEY_CONFLICT = "409";
    public static final String KEY_INTERNAL_SERVER_ERROR = "500";
    public static final String KEY_SET_ALERT_RECIPIENTS_INTERNAL_SERVER_ERROR = "500a";
    public static final String KEY_LIST_ALERT_RECIPIENTS_INTERNAL_SERVER_ERROR = "500b";
    public static final String KEY_CREATE_AVAILABILITY_CHECK_INTERNAL_SERVER_ERROR = "500a";
    public static final String KEY_DELETE_AVAILABILITY_CHECK_INTERNAL_SERVER_ERROR = "500b";
    public static final String KEY_CREATE_JMX_CHECK_INTERNAL_SERVER_ERROR = "500a";
    public static final String KEY_DELETE_JMX_CHECK_INTERNAL_SERVER_ERROR = "500b";
    public static final String KEY_GENERIC_ERROR = "600";
    public static final String KEY_REQUEST_ENTITY_TOO_LARGE = "413";
    public static final String KEY_EXIT_CODE = "exit.code";
    public static final String GROUP_AVAILABILITY = "availability";
    public static final String GROUP_JMX = "jmx";
    public static final String GROUP_RECIPIENTS = "recipients";
    public static final String GROUP_SET_RECIPIENTS = "recipients.set";
    public static final String GROUP_LIST_RECIPIENTS = "recipients.list";
    public static final String GROUP_CREATE_AVAILABILITY_CHECK = "availability.create";
    public static final String GROUP_DELETE_AVAILABILITY_CHECK = "availability.delete";
    public static final String GROUP_CREATE_JMX_CHECK = "jmx.create";
    public static final String GROUP_DELETE_JMX_CHECK = "jmx.delete";
    private static final int EXIT_CODE_MISSING_EXIT_CODE = 400;
    private String group;

    private CommandMessages(String group) {
        this.group = group;
    }

    public static CommandMessages getInstance(String group) {
        if (GROUP_AVAILABILITY.equals(group)) {
            return new CommandMessages(GROUP_AVAILABILITY);
        }
        if (GROUP_JMX.equals(group)) {
            return new CommandMessages(GROUP_JMX);
        }
        if (GROUP_RECIPIENTS.equals(group)) {
            return new CommandMessages(GROUP_RECIPIENTS);
        }
        throw new IllegalArgumentException("Unsupported messages group: " + group);
    }

    public String getMessage(String key) {
        try {
            return RESOURCE_BUNDLE.getString(this.group + "." + key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public String getMessage(int errorCode) {
        try {
            return RESOURCE_BUNDLE.getString(this.group + "." + errorCode);
        }
        catch (MissingResourceException e) {
            return "Mesage with key is missing:" + errorCode;
        }
    }

    public String getMessage(String key, Object ... params) {
        return MessageFormat.format(this.getMessage(key), params);
    }

    public String getMessage(int errorCode, Object ... params) {
        return MessageFormat.format(this.getMessage(errorCode), params);
    }

    public int getExitCode(String errorCode) {
        try {
            String exitCodeString = RESOURCE_BUNDLE.getString(this.group + "." + KEY_EXIT_CODE + "." + errorCode);
            return Integer.parseInt(exitCodeString);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 400;
    }
}

