/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApplicationParameterAnalyzer {
    private static final Pattern APPLICATION_NAME_PATTERN = Pattern.compile("^((\\w+):)?(\\w+)$");
    private String applicationName;
    private String providerAccount;

    public ApplicationParameterAnalyzer(String applicationParam) {
        if (applicationParam == null) {
            this.applicationName = null;
            this.providerAccount = null;
        } else {
            Matcher matcher = APPLICATION_NAME_PATTERN.matcher(applicationParam);
            if (matcher.find()) {
                this.applicationName = matcher.group(3);
                this.providerAccount = matcher.group(2);
            }
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getProviderAccount() {
        return this.providerAccount;
    }

    public boolean consumedThroughtSubscription() {
        return this.providerAccount != null;
    }
}

