/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud;

import com.sap.core.extensions.service.cmd.client.operation.Operation;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ErrorMessageCreator;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.HashMap;
import java.util.Map;

public class ExtensionsCommandErrorRegistry<R> {
    private static final String GENERIC_ERR_MSG = "Failed to execute command. Try again later and if the issue persists contact SAP support.";
    private final Map<Integer, ErrorMessageCreator<R>> errorMessageCreators = new HashMap<Integer, ErrorMessageCreator<R>>();

    public void registerErrorCodeMessage(ErrorCode errorCode, final String message) {
        this.registerErrorCodeHandler(errorCode, new ErrorMessageCreator<R>(){

            @Override
            public String create(Operation<R> operationResult) {
                return message;
            }
        });
    }

    public void registerErrorCodeHandler(ErrorCode errorCode, ErrorMessageCreator<R> errorMessageCreator) {
        this.errorMessageCreators.put(errorCode.getErrorCode(), errorMessageCreator);
    }

    public CommandException getError(Integer errorCode) {
        return this.getError(errorCode, null);
    }

    public CommandException getError(Integer errorCode, Operation<R> operationResult) {
        if (this.errorMessageCreators.containsKey(errorCode)) {
            ErrorMessageCreator<R> errorMessageCreator = this.errorMessageCreators.get(errorCode);
            String message = errorMessageCreator.create(operationResult);
            return new CommandException(message);
        }
        return new CommandException(GENERIC_ERR_MSG);
    }
}

