/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud;

import com.beust.jcommander.Parameter;
import com.sap.core.extensions.service.cmd.commands.ParameterUtils;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExampleValue;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExtensionsGroupCommand;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ParameterFieldsExtractor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ExtensionsCommandExampleGenerator {
    private static final String USER_EXAMPLE_VALUE = "s1234567";
    private static final String HOST_EXAMPLE_VALUE = "hana.ondemand.com";
    private static final String ACCOUNT_EXAMPLE_VALUE = "my_subaccount";
    private static final String NEO_COMMAND_USAGE_PATTERN = "neo %s%s";
    private static final String NEO_COMMAND_PARAMETERS_PATTERN = "%s %s";
    private static final String EMPTY_STRING = "";
    private final ExtensionsGroupCommand cmd;

    public ExtensionsCommandExampleGenerator(ExtensionsGroupCommand cmd) {
        this.cmd = cmd;
    }

    public String generateExample() {
        Map<String, String> commandParameters = this.getCommandParameters();
        return String.format(NEO_COMMAND_USAGE_PATTERN, this.cmd.getName(), this.formatParams(commandParameters));
    }

    private String formatParams(Map<String, String> commandParameters) {
        StringBuilder parameterUsageBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : commandParameters.entrySet()) {
            if (null == entry.getValue()) continue;
            parameterUsageBuilder.append(" ");
            parameterUsageBuilder.append(String.format(NEO_COMMAND_PARAMETERS_PATTERN, entry.getKey(), entry.getValue()));
        }
        return parameterUsageBuilder.toString();
    }

    private Map<String, String> getCommandParameters() {
        Field[] commandFields;
        HashMap<String, String> commandParameters = new HashMap<String, String>();
        this.putBasicAccountParameters(commandParameters);
        ParameterFieldsExtractor paramFieldsExtractor = new ParameterFieldsExtractor();
        for (Field field : commandFields = paramFieldsExtractor.extract((Object)this.cmd)) {
            Parameter parameter = field.getAnnotation(Parameter.class);
            String parameterLongName = ParameterUtils.getParameterLongName(parameter);
            String exampleValue = this.getExampleValue(field);
            commandParameters.put(parameterLongName, exampleValue);
        }
        return commandParameters;
    }

    private String getExampleValue(Field field) {
        ExampleValue exampleValue = field.getAnnotation(ExampleValue.class);
        if (exampleValue != null && !exampleValue.value().trim().isEmpty()) {
            return exampleValue.value();
        }
        return EMPTY_STRING;
    }

    private void putBasicAccountParameters(Map<String, String> commandParameters) {
        commandParameters.put("--account", ACCOUNT_EXAMPLE_VALUE);
        commandParameters.put("--host", HOST_EXAMPLE_VALUE);
        commandParameters.put("--user", USER_EXAMPLE_VALUE);
    }
}

