/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.sap.core.extensions.service.cmd.client.operation.BadOperationRequestException;
import com.sap.core.extensions.service.cmd.client.operation.ErrorResponseBean;
import com.sap.core.extensions.service.cmd.client.operation.Operation;
import com.sap.core.extensions.service.cmd.client.operation.OperationClientFactory;
import com.sap.core.extensions.service.cmd.client.operation.OperationServiceClient;
import com.sap.core.extensions.service.cmd.client.operation.UnauthorizedException;
import com.sap.core.extensions.service.cmd.commands.ParameterUtils;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.AccountErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ErrorMessageCreator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExtensionsCommandErrorRegistry;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExtensionsCommandExampleGenerator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.OperationErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ParameterFieldsExtractor;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.SleepException;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ApplicationParamValidator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.FileExistenceValidator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.FileSizeValidator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.JsonFileValidator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ParamValidator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.RequiredFieldValidator;
import com.sap.core.extensions.service.cmd.commands.progress.OperationProgressMonitor;
import com.sap.jpaas.infrastructure.console.command.AccountCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public abstract class ExtensionsGroupCommand<R>
extends AccountCommand {
    private static final String EMPTY_STRING = "";
    private static final String RESTRCTION_VIOLATION_ERR_MSG = "Cannot execute '%s'. The operation feature is not enabled for subaccount '%s'.";
    private static final String MISSING_PERMISSIONS_VIOLATION_ERR_MSG = "User '%s' does not have permissions to execute '%s' on subaccount '%s'.";
    private static final String MISSING_PARAMETER_ERR_MSG = "Required operation parameter is missing. Provide the missing parameter.";
    private static final String INVALID_PARAMETER_ERR_MSG = "Operation parameter is invalid.";
    private static final String TIMEOUT_ERR_MSG = "Timeout was reached waiting for operation to complete.";
    private static final String DISABLED_BETA_FEATURE_ERR_MSG_PATTERN = "Beta feature is not enabled for subaccount '%s'.";
    private static final String DISABLED_COMPANY_INTEGRATION_ERR_MSG_PATTERN = "The link from SAP SuccessFactors company, associated with account '%s', is disabled";
    private static final Logger LOGGER = Logger.getLogger(ExtensionsGroupCommand.class);
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final String START_PROCESSING_OPERATION_MSG = "Executing [%s] command with arguments: ";
    private static final String EXTENSIONS_COMMANDS_GROUP_NAME = "extensions";
    private static final int COMMAND_EXECUTION_TIMEOUT_MILLIS = 60000;
    private static final int CONNECTION_TIMEOUT_MILLIS = 30000;
    private static final int READ_TIMEOUT_MILLIS = 240000;
    private static final int POLL_INTERVAL_MILLIS = 5000;
    protected final ExtensionsCommandExampleGenerator exampleGenerator = new ExtensionsCommandExampleGenerator(this);
    protected OperationServiceClient operationsClient;
    private final OperationClientFactory operationClientFactory;
    private final ExtensionsCommandErrorRegistry<R> errorRegistry;
    private HttpClient httpClient;
    private ParamValidator[] paramValidators;

    public ExtensionsGroupCommand() {
        this(new OperationClientFactory(), new ExtensionsCommandErrorRegistry(), new RequiredFieldValidator(), new ApplicationParamValidator(), new FileExistenceValidator(), new FileSizeValidator(), new JsonFileValidator());
    }

    public ExtensionsGroupCommand(OperationClientFactory operationClientFactory, ExtensionsCommandErrorRegistry<R> errorHandler, ParamValidator ... paramValidators) {
        this.operationClientFactory = operationClientFactory;
        this.errorRegistry = errorHandler;
        this.paramValidators = paramValidators;
    }

    public String getGroup() {
        return EXTENSIONS_COMMANDS_GROUP_NAME;
    }

    public String getExample() {
        return this.exampleGenerator.generateExample();
    }

    public void init() throws CommandException {
        try {
            super.init();
            this.validateParameters();
            this.initializeGenericErrors();
            this.registerCommandSpecificErrors();
        }
        catch (CommandException e) {
            throw e;
        }
        catch (ParameterException ex) {
            throw ex;
        }
        catch (Exception e) {
            String errorMessage = this.getBackendErrorMessage();
            LOGGER.error((Object)errorMessage, (Throwable)e);
            throw new CommandException(errorMessage);
        }
    }

    private void validateParameters() {
        for (ParamValidator validator : this.paramValidators) {
            validator.validate(this);
        }
        this.validateInput();
    }

    private void initializeGenericErrors() {
        this.registerError((ErrorCode)AccountErrorCode.NOT_EXTENSION_ACCOUNT, this.getNotExtensionAccountErrorMessage());
        this.registerError((ErrorCode)AccountErrorCode.NOT_AUTHORIZED_ACCOUNT, String.format(MISSING_PERMISSIONS_VIOLATION_ERR_MSG, this.getUser(), this.getName(), this.getAccount()));
        this.registerError((ErrorCode)OperationErrorCode.BACKEND_FAILURE, this.getBackendErrorMessage());
        this.registerError((ErrorCode)OperationErrorCode.FEATURE_RESTRICTION, String.format(RESTRCTION_VIOLATION_ERR_MSG, this.getName(), this.getAccount()));
        this.registerError((ErrorCode)OperationErrorCode.MISSING_PARAMETER, MISSING_PARAMETER_ERR_MSG);
        this.registerError((ErrorCode)OperationErrorCode.INVALID_PARAMETER, INVALID_PARAMETER_ERR_MSG);
        this.registerError((ErrorCode)OperationErrorCode.TIMEOUT, TIMEOUT_ERR_MSG);
        this.registerError(OperationErrorCode.BETA_FEATURE_NOT_ENABLED, DISABLED_BETA_FEATURE_ERR_MSG_PATTERN, this.account);
        this.registerError(OperationErrorCode.COMPANY_INTEGRATION_DISABLED, DISABLED_COMPANY_INTEGRATION_ERR_MSG_PATTERN, this.account);
    }

    protected abstract String getNotExtensionAccountErrorMessage();

    protected abstract String getBackendErrorMessage();

    protected abstract void registerCommandSpecificErrors();

    protected void validateInput() {
    }

    protected final void registerError(ErrorCode errorCode, String messageTemplate, Object ... messageParams) {
        String message = String.format(messageTemplate, messageParams);
        this.registerError(errorCode, message);
    }

    protected final void registerError(ErrorCode errorCode, String message) {
        this.errorRegistry.registerErrorCodeMessage(errorCode, message);
    }

    protected final void registerError(ErrorCode errorCode, ErrorMessageCreator<R> errorMessageCreator) {
        this.errorRegistry.registerErrorCodeHandler(errorCode, errorMessageCreator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws CommandException {
        DumpHelper.dumpOperationList((String)this.getUser(), (String)String.format(START_PROCESSING_OPERATION_MSG, this.getName()), (Object[])this.getParameters());
        OperationProgressMonitor progMonitor = new OperationProgressMonitor(this.getCommandExecutingMessage());
        Operation<R> completedOperation = null;
        try {
            this.operationsClient = this.createOperationsClient();
            progMonitor.startMonitor();
            completedOperation = this.executeCommand();
        }
        finally {
            progMonitor.stopMonitor();
            DumpHelper.dumpWithNewLine((String)EMPTY_STRING);
        }
        String successMessage = this.getSuccessMessage(completedOperation);
        DumpHelper.dumpWithNewLine((String)successMessage);
    }

    protected Object[] getParameters() {
        ArrayList<String> args = new ArrayList<String>();
        Collections.addAll(args, this.getParameterName("--host"), this.getHost());
        Collections.addAll(args, this.getParameterName("--account"), this.getAccount());
        ParameterFieldsExtractor parameterFieldsExtractor = new ParameterFieldsExtractor();
        for (Field field : parameterFieldsExtractor.extract((Object)this)) {
            Parameter parameter = field.getAnnotation(Parameter.class);
            if (parameter == null) continue;
            this.addParameter(args, field, parameter);
        }
        return args.toArray();
    }

    private String getParameterName(String paramLongName) {
        return paramLongName.replaceAll("--", EMPTY_STRING);
    }

    private void addParameter(List<String> args, Field field, Parameter parameter) {
        if (parameter.names().length == 0) {
            return;
        }
        String parameterLongName = ParameterUtils.getParameterLongName(parameter);
        try {
            field.setAccessible(true);
            Object fieldValue = field.get((Object)this);
            if (fieldValue != null) {
                this.addParameterValue(args, field, parameterLongName, fieldValue);
            }
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Could not obtain command parameters for command [" + this.getName() + "]", ex);
        }
        finally {
            field.setAccessible(false);
        }
    }

    private void addParameterValue(List<String> args, Field field, String parameterLongName, Object fieldValue) {
        String value = String.valueOf(fieldValue);
        if (field.getType().equals(Boolean.TYPE)) {
            this.addBooleanParameter(args, parameterLongName, value);
        } else {
            Collections.addAll(args, this.getParameterName(parameterLongName), value);
        }
    }

    private void addBooleanParameter(List<String> args, String parameterLongName, String value) {
        if (Boolean.parseBoolean(value)) {
            Collections.addAll(args, this.getParameterName(parameterLongName), value);
        }
    }

    protected abstract String getCommandExecutingMessage();

    protected OperationServiceClient createOperationsClient() {
        this.httpClient = this.getHttpClient();
        this.httpClient.getParams().setParameter("http.connection.timeout", (Object)30000);
        this.httpClient.getParams().setParameter("http.socket.timeout", (Object)240000);
        return this.operationClientFactory.getClient(this.httpClient, this.getHost());
    }

    private Operation<R> executeCommand() {
        try {
            long operationId = this.createOperation(this.getAccount());
            LOGGER.debug((Object)("Created operation with id " + operationId));
            Operation<R> completedOperationResult = this.waitOperationProcessing(operationId);
            if (!Operation.Status.SUCCESS.name().equals(completedOperationResult.getStatus().name())) {
                throw this.getError(completedOperationResult.getErrorCode(), completedOperationResult);
            }
            return completedOperationResult;
        }
        catch (CommandException e) {
            throw e;
        }
        catch (UnauthorizedException e) {
            String authorizationFailedMsg = this.getAuthorizationFailedMsg();
            LOGGER.error((Object)authorizationFailedMsg, (Throwable)e);
            throw new CommandException(authorizationFailedMsg);
        }
        catch (BadOperationRequestException ex) {
            LOGGER.error((Object)"Operation error.", (Throwable)ex);
            ErrorResponseBean response = ex.getResponseBean();
            throw this.getError(response.getErrorCode());
        }
        catch (ParameterException ex) {
            LOGGER.error((Object)"Invalid parameter value.", (Throwable)ex);
            throw ex;
        }
        catch (Exception e) {
            String errorMessage = this.getBackendErrorMessage();
            LOGGER.error((Object)errorMessage, (Throwable)e);
            throw new CommandException(errorMessage);
        }
    }

    protected abstract long createOperation(String var1);

    private Operation<R> waitOperationProcessing(long operationId) {
        long endTimeInMillis = System.currentTimeMillis() + 60000L;
        Operation<R> operationResult = this.getOperation(this.getAccount(), operationId);
        while (this.isStillProcessing(operationResult) && System.currentTimeMillis() < endTimeInMillis) {
            this.sleep(5000L);
            operationResult = this.getOperation(this.getAccount(), operationId);
        }
        return this.isStillProcessing(operationResult) ? Operation.error((Integer)OperationErrorCode.TIMEOUT.getErrorCode()) : operationResult;
    }

    protected abstract Operation<R> getOperation(String var1, long var2);

    private boolean isStillProcessing(Operation<R> operation) {
        return Operation.Status.PROCESSING.name().equals(operation.getStatus().name());
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            throw new SleepException("The sleep for " + millis + "ms was interrupted", ex);
        }
    }

    private CommandException getError(Integer errorCode) throws CommandException {
        LOGGER.error((Object)("Failed operation execution! Error code: " + errorCode));
        return this.errorRegistry.getError(errorCode);
    }

    private CommandException getError(Integer errorCode, Operation<R> completedOperationResult) {
        LOGGER.error((Object)("Failed operation execution! Error code: " + errorCode));
        return this.errorRegistry.getError(errorCode, completedOperationResult);
    }

    private String getAuthorizationFailedMsg() {
        StringBuilder authorizationMsg = new StringBuilder();
        authorizationMsg.append("Authorization failed. Check if:");
        authorizationMsg.append(LINE_SEPARATOR);
        authorizationMsg.append("1. the subaccount name and the host are correct");
        authorizationMsg.append(LINE_SEPARATOR);
        authorizationMsg.append("2. the provided user has rights to perform the operation in the specified subaccount");
        return authorizationMsg.toString();
    }

    protected abstract String getSuccessMessage(Operation<R> var1);

    public void cleanup() throws CommandException {
        if (this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
        }
    }
}

