/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.acs;

import com.beust.jcommander.Parameter;
import com.sap.core.extensions.service.cmd.client.operation.ApplicationAccess;
import com.sap.core.extensions.service.cmd.client.operation.ApplicationType;
import com.sap.core.extensions.service.cmd.client.operation.TypeApplicationParams;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ApplicationParameterAnalyzer;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ApplicationTypeValidator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExampleValue;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExtensionsGroupCommand;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.acs.SuccessMessageCreator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.acs.SuccessMessageParams;
import java.util.List;

public abstract class ApplicationAccessCommand<R>
extends ExtensionsGroupCommand<R> {
    @ExampleValue(value="java")
    @Parameter(names={"--application-type"}, description="Type of the application. Valid values are 'java' or 'html5'. Default value is 'java'.", validateWith=ApplicationTypeValidator.class)
    protected String type;
    private final SuccessMessageCreator successMessageCreator;

    public ApplicationAccessCommand() {
        this(new SuccessMessageCreator());
    }

    public ApplicationAccessCommand(SuccessMessageCreator successMessageCreator) {
        this.successMessageCreator = successMessageCreator;
    }

    @Override
    protected String getSuccessMessage(List<ApplicationAccess> acses) {
        SuccessMessageParams msgParams = new SuccessMessageParams();
        msgParams.setBasicSuccessMessage(this.getBasicSuccessMessage());
        msgParams.setAcses(acses);
        return this.successMessageCreator.createMessage(msgParams);
    }

    protected abstract String getBasicSuccessMessage();

    protected abstract String getApplication();

    protected TypeApplicationParams createOperationParameters() {
        ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.getApplication());
        String providerAccount = appParamAnalyzer.consumedThroughtSubscription() ? appParamAnalyzer.getProviderAccount() : null;
        TypeApplicationParams params = new TypeApplicationParams(appParamAnalyzer.getApplicationName(), providerAccount, this.getAppType());
        return params;
    }

    protected ApplicationType getAppType() {
        if (this.type == null || this.type.isEmpty()) {
            return ApplicationType.JAVA;
        }
        return (ApplicationType)ApplicationType.getConsoleValues().get(this.type);
    }
}

