/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.acs;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.extensions.service.cmd.client.operation.ApplicationAccess;
import com.sap.core.extensions.service.cmd.client.operation.Operation;
import com.sap.core.extensions.service.cmd.client.operation.TypeApplicationParams;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ApplicationParameterAnalyzer;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExampleValue;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.OperationErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.acs.ApplicationAccessCommand;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ApplicationParam;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.RequiredField;
import com.sap.jpaas.infrastructure.console.ConsoleLogger;
import java.util.List;

@Parameters(commandDescription="Disables an extension application to use SAP SuccessFactors Identity Provider for authentication by removing the application URL from Assertion Consumer Services whitelist. If an entry for the extension application does not exist in the whitelist, the command fails to execute.")
public class DisableApplicationAccessCommand
extends ApplicationAccessCommand<List<ApplicationAccess>> {
    private static final ConsoleLogger LOGGER = ConsoleLogger.getLogger(DisableApplicationAccessCommand.class);
    static final String COMMAND_DESCRIPTION = "Disables an extension application to use SAP SuccessFactors Identity Provider for authentication by removing the application URL from Assertion Consumer Services whitelist. If an entry for the extension application does not exist in the whitelist, the command fails to execute.";
    private static final String COMMAND_NAME = "hcmcloud-disable-application-access";
    private static final String COMMAND_EXECUTION_MSG = "Disabling application access...";
    private static final String BASIC_SUCCESS_MSG = "Application access was disabled for application '%s' from subaccount '%s'.";
    private static final String NOT_EXTENSION_ACCOUNT_ERROR_MSG = "Cannot disable application access. Subaccount '%s' is not linked to an SAP SuccessFactors system";
    private static final String APPLICATION_NOT_FOUND_MSG = "Cannot disable application access. No application with name '%s' was found in subaccount '%s'";
    private static final String CONSUMER_NOT_SUBSCRIBED_MSG = "Cannot disable application access. Subaccount '%s' must be subscribed to the application '%s' in the provided subaccount '%s'.";
    private static final String BACKEND_ERROR_MSG = "Cannot disable application access. Try again later and if the issue persists, contact SAP support.";
    @RequiredField
    @ApplicationParam(required=true)
    @ExampleValue(value="my_extension_application")
    @Parameter(names={"--application", "-b"}, description="The name of the extension application for which you want to disable access.")
    protected String application;

    @Override
    protected String getSuccessMessage(Operation<List<ApplicationAccess>> operationResult) {
        List acses = (List)operationResult.getResult();
        LOGGER.debug(new Object[]{"Disabled ACS entries: ", acses});
        return this.getBasicSuccessMessage();
    }

    @Override
    protected void registerCommandSpecificErrors() {
        ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        String providerAccount = appParamAnalyzer.getProviderAccount();
        String applicationProvider = appParamAnalyzer.consumedThroughtSubscription() ? providerAccount : this.getAccount();
        String applicationName = appParamAnalyzer.getApplicationName();
        this.registerError(OperationErrorCode.APPLICATION_NOT_FOUND, APPLICATION_NOT_FOUND_MSG, applicationName, applicationProvider);
        this.registerError(OperationErrorCode.CONSUMER_NOT_SUBSCRIBED, CONSUMER_NOT_SUBSCRIBED_MSG, this.getAccount(), applicationName, providerAccount);
    }

    @Override
    protected String getCommandExecutingMessage() {
        return COMMAND_EXECUTION_MSG;
    }

    @Override
    protected String getNotExtensionAccountErrorMessage() {
        return String.format(NOT_EXTENSION_ACCOUNT_ERROR_MSG, this.getAccount());
    }

    @Override
    protected String getBackendErrorMessage() {
        return BACKEND_ERROR_MSG;
    }

    @Override
    protected String getBasicSuccessMessage() {
        ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        return String.format(BASIC_SUCCESS_MSG, appParamAnalyzer.getApplicationName(), this.getAccount());
    }

    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    protected String getApplication() {
        return this.application;
    }

    @Override
    protected long createOperation(String accountId) {
        TypeApplicationParams params = this.createOperationParameters();
        return this.operationsClient.createDisableApplicationAccessOperation(accountId, params);
    }

    @Override
    protected Operation<List<ApplicationAccess>> getOperation(String accountId, long operationId) {
        return this.operationsClient.getDisableApplicationAccessOperation(accountId, operationId);
    }
}

