/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.acs;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.extensions.service.cmd.client.operation.ApplicationAccess;
import com.sap.core.extensions.service.cmd.client.operation.Operation;
import com.sap.core.extensions.service.cmd.client.operation.TypeApplicationParams;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ApplicationParameterAnalyzer;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExampleValue;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.OperationErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.acs.AccessStatusFormatter;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.acs.AppAccessCommandErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.acs.ApplicationAccessCommand;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.acs.EnableApplicationAccessCommand;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.acs.SuccessMessageCreator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ApplicationParam;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.RequiredField;
import java.util.List;

@Parameters(commandDescription="Returns the status of the extension application's access to SAP SuccessFactors. Status is given for all extension application access point URLs.")
public class DisplayApplicationAccessCommand
extends ApplicationAccessCommand<List<ApplicationAccess>> {
    static final String COMMAND_DESCRIPTION = "Returns the status of the extension application's access to SAP SuccessFactors. Status is given for all extension application access point URLs.";
    private static final String COMMAND_NAME = "hcmcloud-display-application-access-status";
    private static final String COMMAND_EXECUTION_MSG = "Displaying application access status...";
    private static final String BASIC_SUCCESS_MSG = "Access to SAP SuccessFactors for '%s' application '%s' from subaccount '%s':";
    private static final String NOT_EXTENSION_ACCOUNT_MSG = "Cannot display application access status. Subaccount '%s' is not linked to an SAP SuccessFactors system.";
    private static final String BACKEND_ERR_MSG = "Cannot display application access status. Try again later and if the issue persists contact SAP support.";
    private static final String APPLICATION_NOT_FOUND_MSG = "Cannot display application access status. No application with name '%s' was found in subaccount '%s'";
    private static final String CONSUMER_NOT_SUBSCRIBED_MSG = "Cannot display application access status. Subaccount '%s' must be subscribed to the provided application '%s' in subaccount '%s'.";
    private static final String NOT_CORRECTLY_CONFIGURED_FIX_SUGGESTION = "You have access points, which are not configured correctly. To configure the access points, execute the '%s' command for application '%s'.";
    private static final String MISSING_APPLICATION_URL_MSG = "Cannot display application access status. The application URL cannot be determined for application '%s' in subaccount '%s'. Make sure the application is started.";
    private static final String APPLICATION_NOT_STARTED_MSG = "Cannot display application access status. The application URL cannot be determined. Check if the application '%s' in subaccount '%s' is started.";
    @RequiredField
    @ApplicationParam(required=true)
    @ExampleValue(value="my_extension_application")
    @Parameter(names={"--application", "-b"}, description="The name of the extension application for which you want to display the access status.")
    protected String application;

    public DisplayApplicationAccessCommand() {
        super(new SuccessMessageCreator(new AccessStatusFormatter()));
    }

    @Override
    protected String getSuccessMessage(Operation<List<ApplicationAccess>> operationResult) {
        List acses = (List)operationResult.getResult();
        String successMessage = this.getSuccessMessage(acses);
        if (this.isApplicationAccessWronglyConfigured(successMessage)) {
            String fixSuggestion = String.format(NOT_CORRECTLY_CONFIGURED_FIX_SUGGESTION, new EnableApplicationAccessCommand().getName(), this.application);
            successMessage = successMessage + LINE_SEPARATOR + fixSuggestion;
        }
        return successMessage;
    }

    @Override
    protected void registerCommandSpecificErrors() {
        ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        String providerAccount = appParamAnalyzer.getProviderAccount();
        String applicationProvider = appParamAnalyzer.consumedThroughtSubscription() ? providerAccount : this.getAccount();
        String applicationName = appParamAnalyzer.getApplicationName();
        this.registerError(OperationErrorCode.APPLICATION_NOT_FOUND, APPLICATION_NOT_FOUND_MSG, applicationName, applicationProvider);
        this.registerError(OperationErrorCode.CONSUMER_NOT_SUBSCRIBED, CONSUMER_NOT_SUBSCRIBED_MSG, this.getAccount(), applicationName, providerAccount);
        this.registerError(AppAccessCommandErrorCode.APPLICATION_NOT_STARTED, APPLICATION_NOT_STARTED_MSG, applicationName, applicationProvider);
        this.registerError(AppAccessCommandErrorCode.MISSING_APPLICATION_URL, MISSING_APPLICATION_URL_MSG, applicationName, applicationProvider);
    }

    @Override
    protected String getBasicSuccessMessage() {
        ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        return String.format(BASIC_SUCCESS_MSG, this.getAppType().getConsoleValue(), appParamAnalyzer.getApplicationName(), this.getAccount());
    }

    @Override
    protected String getApplication() {
        return this.application;
    }

    @Override
    protected String getCommandExecutingMessage() {
        return COMMAND_EXECUTION_MSG;
    }

    @Override
    protected String getNotExtensionAccountErrorMessage() {
        return String.format(NOT_EXTENSION_ACCOUNT_MSG, this.getAccount());
    }

    @Override
    protected String getBackendErrorMessage() {
        return BACKEND_ERR_MSG;
    }

    public String getName() {
        return COMMAND_NAME;
    }

    private boolean isApplicationAccessWronglyConfigured(String successMessage) {
        return successMessage.contains(ApplicationAccess.ApplicationAccessStatus.MISCONFIGURED.name()) || successMessage.contains(ApplicationAccess.ApplicationAccessStatus.MISSING.name());
    }

    @Override
    protected long createOperation(String accountId) {
        TypeApplicationParams params = this.createOperationParameters();
        return this.operationsClient.createDisplayAccessOperation(accountId, params);
    }

    @Override
    protected Operation<List<ApplicationAccess>> getOperation(String accountId, long operationId) {
        return this.operationsClient.getDisplayAccessOperation(accountId, operationId);
    }
}

