/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.acs;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.extensions.service.cmd.client.operation.ApplicationAccess;
import com.sap.core.extensions.service.cmd.client.operation.Operation;
import com.sap.core.extensions.service.cmd.client.operation.TypeApplicationParams;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ApplicationParameterAnalyzer;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExampleValue;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.OperationErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.acs.AppAccessCommandErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.acs.ApplicationAccessCommand;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.acs.SuccessMessageCreator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ApplicationParam;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.RequiredField;
import java.util.Arrays;
import java.util.List;

@Parameters(commandDescription="Enables an extension application to use the SAP SuccessFactors Identity Provider for authentication by whitelisting the application URL in the Assertion Consumer Services.")
public class EnableApplicationAccessCommand
extends ApplicationAccessCommand<ApplicationAccess> {
    static final String COMMAND_DESCRIPTION = "Enables an extension application to use the SAP SuccessFactors Identity Provider for authentication by whitelisting the application URL in the Assertion Consumer Services.";
    private static final String COMMAND_NAME = "hcmcloud-enable-application-access";
    private static final String EXECUTING_MESSAGE = "Enabling application access...";
    private static final String NOT_EXTENSION_ACCOUNT_ERR_MSG_PATTERN = "Cannot enable application access. Subaccount '%s' is not linked to an SAP SuccessFactors system.";
    private static final String BACKEND_ERR_MSG = "Cannot enable application access. Try again later and if the issue persists, contact SAP support.";
    private static final String BASIC_SUCCESS_MSG = "Application access was enabled for application '%s' from subaccount '%s':";
    @RequiredField
    @ApplicationParam(required=true)
    @ExampleValue(value="my_extension_application")
    @Parameter(names={"--application", "-b"}, description="The name of the extension application for which you want to enable access.")
    protected String application;

    public EnableApplicationAccessCommand() {
        super(new SuccessMessageCreator());
    }

    public EnableApplicationAccessCommand(SuccessMessageCreator successMessageCreator) {
        super(successMessageCreator);
    }

    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    protected String getCommandExecutingMessage() {
        return EXECUTING_MESSAGE;
    }

    @Override
    protected String getNotExtensionAccountErrorMessage() {
        return String.format(NOT_EXTENSION_ACCOUNT_ERR_MSG_PATTERN, this.account);
    }

    @Override
    protected String getBackendErrorMessage() {
        return BACKEND_ERR_MSG;
    }

    @Override
    protected String getSuccessMessage(Operation<ApplicationAccess> operationResult) {
        ApplicationAccess createdACS = (ApplicationAccess)operationResult.getResult();
        List<ApplicationAccess> acses = Arrays.asList(createdACS);
        return this.getSuccessMessage(acses);
    }

    @Override
    protected void registerCommandSpecificErrors() {
        ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        String targetAccount = null != appParamAnalyzer.getProviderAccount() ? appParamAnalyzer.getProviderAccount() : this.account;
        String appName = appParamAnalyzer.getApplicationName();
        this.registerError(OperationErrorCode.APPLICATION_NOT_FOUND, "Cannot enable application access. Application with name '%s' of type '%s' was not found in the provided subaccount '%s'.", appName, this.getAppType().getConsoleValue(), targetAccount);
        this.registerError(OperationErrorCode.CONSUMER_NOT_SUBSCRIBED, "Cannot enable application access. Subaccount '%s' must be subscribed to the provided application '%s' of type '%s' in subaccount '%s'.", this.account, appName, this.getAppType().getConsoleValue(), targetAccount);
        this.registerError(AppAccessCommandErrorCode.MISSING_APPLICATION_URL, "Cannot enable application access. The application URL cannot be determined for application '%s' of type '%s' in subaccount '%s'. Make sure the application is started.", appName, this.getAppType().getConsoleValue(), targetAccount);
        this.registerError(AppAccessCommandErrorCode.MISSING_SP_AUDIENCE_URL, "Cannot enable application access. The service provider audience URL cannot be determined for subaccount '%s'. Make sure subaccount trust settings are configured correctly.", targetAccount);
        this.registerError(AppAccessCommandErrorCode.MISSING_SP_LOGOUT_URL, "Cannot enable application access. The service provider logout URL cannot be determined for subaccount '%s'. Make sure subaccount trust settings are configured correctly.", this.account);
        this.registerError(AppAccessCommandErrorCode.ACS_ALREADY_CONFIGURED, "Cannot enable application access. Access configuartion for application '%s' of type '%s' in subaccount '%s' already exists.", appName, this.getAppType().getConsoleValue(), targetAccount);
        this.registerError(AppAccessCommandErrorCode.APPLICATION_NOT_STARTED, "Cannot enable application access. The application URL cannot be determined. Check if the application '%s' of type '%s' in subaccount '%s' is started.", appName, this.getAppType().getConsoleValue(), targetAccount);
    }

    @Override
    protected String getBasicSuccessMessage() {
        ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        return String.format(BASIC_SUCCESS_MSG, appParamAnalyzer.getApplicationName(), this.getAccount());
    }

    @Override
    protected String getApplication() {
        return this.application;
    }

    @Override
    protected long createOperation(String accountId) {
        TypeApplicationParams params = this.createOperationParameters();
        return this.operationsClient.createEnableAccessOperation(accountId, params);
    }

    @Override
    protected Operation<ApplicationAccess> getOperation(String accountId, long operationId) {
        return this.operationsClient.getEnableAccessOperation(accountId, operationId);
    }
}

