/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.connectivity;

import com.sap.core.extensions.service.cmd.client.operation.Connection;
import java.util.List;

class ConnectionListFormatter {
    private static final String MISSING_USER = "";
    private static final String PROPS_ALIGN_FORMAT = "%-16s : %s%n";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    ConnectionListFormatter() {
    }

    String format(List<Connection> connections) {
        StringBuilder connectionsListBuilder = new StringBuilder();
        connectionsListBuilder.append("<< List of connections >>");
        connectionsListBuilder.append(LINE_SEPARATOR);
        connectionsListBuilder.append(LINE_SEPARATOR);
        for (Connection connection : connections) {
            connectionsListBuilder.append(String.format(PROPS_ALIGN_FORMAT, "Connection Name", connection.getName()));
            connectionsListBuilder.append(String.format(PROPS_ALIGN_FORMAT, "Technical User", this.getTechnicalUser(connection)));
            connectionsListBuilder.append(String.format(PROPS_ALIGN_FORMAT, "Connection State", connection.getState().name()));
            connectionsListBuilder.append(LINE_SEPARATOR);
        }
        if (connections.isEmpty()) {
            connectionsListBuilder.append("There are no connections to display");
        }
        return connectionsListBuilder.toString();
    }

    private String getTechnicalUser(Connection connection) {
        return connection.getUser() != null ? connection.getUser() : MISSING_USER;
    }
}

