/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.connectivity;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.core.extensions.service.cmd.client.operation.ConnectionParams;
import com.sap.core.extensions.service.cmd.client.operation.OAuthDestination;
import com.sap.core.extensions.service.cmd.client.operation.Operation;
import com.sap.core.extensions.service.cmd.client.operation.SubscriptionParams;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ApplicationLevelDeterminator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ApplicationParameterAnalyzer;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ConnectionNameValidator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExampleValue;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExtensionsGroupCommand;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.OperationErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.connectivity.ConnectionErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.connectivity.TechnicalUserValidator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ApplicationParam;

@Parameters(commandDescription="1. Creates and configures a connection between a Java application and the extended SAP SuccessFactors instance.\n2. Creates and configures a connection between a subaccount and the extended SAP SuccessFactors instance.")
public class CreateConnectionCommand
extends ExtensionsGroupCommand<OAuthDestination> {
    static final String CONFIGURE_CONNECTIVITY_COMMAND_DESCRIPTION = "1. Creates and configures a connection between a Java application and the extended SAP SuccessFactors instance.\n2. Creates and configures a connection between a subaccount and the extended SAP SuccessFactors instance.";
    private static final String HCMCLOUD_CONFIGURE_CONNECTION_CMD_NAME = "hcmcloud-create-connection";
    private static final String CONFIGURING_CONNECTIVITY_EXECUTION_MSG = "Configuring connection...";
    private static final String SUCCESS_MSG_FOR_APPLICATION = "Connection '%s' to SAP SuccessFactors was created for application '%s'.";
    private static final String SUCCESS_MSG_FOR_SUBACCOUNT = "Connection '%s' to SAP SuccessFactors was created for subaccount '%s'.";
    private static final String APPLICATION_NOT_FOUND_ERR_MSG_PATERN = "Invalid value in parameter --application. Application '%s' was not found in the provided subaccount '%s'.";
    private static final String BACKEND_ERR_MSG = "Cannot connect to the SAP SuccessFactors system. Try again later and if the issue persists, contact SAP support.";
    private static final String CONNECTION_NAMING_CONFLICT_ON_APPLICATION_LEVEL_ERR_MSG_PATTERN = "Cannot create the connection. Connection for application '%s' already exists.";
    private static final String CONNECTION_NAMING_CONFLICT_ON_SUBACCOUNT_LEVEL_ERR_MSG_PATTERN = "Cannot create the connection. Connection for subaccount '%s' already exists.";
    private static final String CUNSUMER_NOT_SUBSCRIBED_MSG_PATTERN = "Cannot create the connection. Subaccount '%s' must be subscribed to the provided application '%s'.";
    private static final String NOT_EXTENSION_ACCOUNT_ERR_MSG_PATTERN = "Cannot create an SAP SuccessFactors connection. Subaccount '%s' is not linked to an SAP SuccessFactors system.";
    private static final String SAP_HCMCLOUD_CORE_ODATA = "sap_hcmcloud_core_odata";
    private static final String SAP_HCMCLOUD_CORE_ODATA_TECHNICAL_USER = "sap_hcmcloud_core_odata_technical_user";
    @ApplicationParam(required=false)
    @Parameter(names={"-b", "--application"}, description="The name of the extension application for which you are creating the connection.\n  Syntax:\n  1. '--application <my_extension_application>' if the application is running in your subaccount;\n  2. '--application <provider_subaccount>:<extension_application>' if the application is running in another subaccount and your extension subaccount is subscribed to the application.")
    @ExampleValue(value="my_extension_application")
    private String application;
    @Parameter(names={"-w", "--overwrite"}, description="If a connection with the same name already exists, the command overwrites it. If you do not explicitly specify the --overwrite parameter, and a connection with the same name already exists, the command fails to execute.")
    @ExampleValue(value="")
    private boolean overwrite = false;
    @Parameter(names={"--technical-user-id"}, description="ID of the technical user for the connection.", validateWith=TechnicalUserValidator.class)
    @ExampleValue(value="my_technical-user-id")
    private String technicalUser;
    @Parameter(names={"-n", "--name"}, description="Name of the connection, which you are creating.", validateWith=ConnectionNameValidator.class)
    @ExampleValue(value="sap_hcmcloud_core_odata")
    private String name;

    @Override
    protected String getNotExtensionAccountErrorMessage() {
        return String.format(NOT_EXTENSION_ACCOUNT_ERR_MSG_PATTERN, this.account);
    }

    @Override
    protected String getBackendErrorMessage() {
        return BACKEND_ERR_MSG;
    }

    @Override
    protected void registerCommandSpecificErrors() {
        ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        String appName = appParamAnalyzer.getApplicationName();
        String targetAccount = null != appParamAnalyzer.getProviderAccount() ? appParamAnalyzer.getProviderAccount() : this.account;
        this.registerError(OperationErrorCode.CONSUMER_NOT_SUBSCRIBED, CUNSUMER_NOT_SUBSCRIBED_MSG_PATTERN, this.account, appName);
        this.registerError(OperationErrorCode.APPLICATION_NOT_FOUND, APPLICATION_NOT_FOUND_ERR_MSG_PATERN, appName, targetAccount);
        if (ApplicationLevelDeterminator.isOnApplicationLevel(this.application)) {
            this.registerError(ConnectionErrorCode.CONNECTION_NAMING_CONFLICT, CONNECTION_NAMING_CONFLICT_ON_APPLICATION_LEVEL_ERR_MSG_PATTERN, appName);
        } else {
            this.registerError(ConnectionErrorCode.CONNECTION_NAMING_CONFLICT, CONNECTION_NAMING_CONFLICT_ON_SUBACCOUNT_LEVEL_ERR_MSG_PATTERN, this.account);
        }
    }

    @Override
    protected String getCommandExecutingMessage() {
        return CONFIGURING_CONNECTIVITY_EXECUTION_MSG;
    }

    @Override
    protected long createOperation(String accountId) {
        ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        SubscriptionParams subscriptionParams = new SubscriptionParams(appParamAnalyzer.getApplicationName(), appParamAnalyzer.consumedThroughtSubscription() ? appParamAnalyzer.getProviderAccount() : null);
        ConnectionParams connectionParams = new ConnectionParams(subscriptionParams, this.technicalUser, this.overwrite, this.name);
        return this.operationsClient.createConfigureConnectionOperation(this.account, connectionParams);
    }

    @Override
    protected Operation<OAuthDestination> getOperation(String accountId, long operationId) {
        return this.operationsClient.getConfigureConnectionOperation(accountId, operationId);
    }

    @Override
    protected String getSuccessMessage(Operation<OAuthDestination> operationResult) {
        ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        String appName = appParamAnalyzer.getApplicationName();
        OAuthDestination result = (OAuthDestination)operationResult.getResult();
        String destinationName = result.getDestinationName();
        String oAuthClientName = result.getOAuthClientName();
        StringBuilder successMsgBuilder = this.constructSuccessMessage(destinationName, appName);
        if (oAuthClientName != null) {
            successMsgBuilder.append(LINE_SEPARATOR);
            successMsgBuilder.append("Created OAuth client with name '").append(oAuthClientName).append("'.");
        }
        successMsgBuilder.append(LINE_SEPARATOR);
        successMsgBuilder.append("Created destination with name '").append(destinationName).append("'.");
        return successMsgBuilder.toString();
    }

    private StringBuilder constructSuccessMessage(String destinationName, String appName) {
        if (ApplicationLevelDeterminator.isOnApplicationLevel(this.application)) {
            return new StringBuilder().append(String.format(SUCCESS_MSG_FOR_APPLICATION, destinationName, appName));
        }
        return new StringBuilder().append(String.format(SUCCESS_MSG_FOR_SUBACCOUNT, destinationName, this.account));
    }

    public String getName() {
        return HCMCLOUD_CONFIGURE_CONNECTION_CMD_NAME;
    }

    @Override
    protected void validateInput() {
        this.validateAccountLevelNameIsNotNull();
        this.validateAccountLevelNameIsNotDefault();
    }

    private void validateAccountLevelNameIsNotNull() {
        if (!ApplicationLevelDeterminator.isOnApplicationLevel(this.application) && this.name == null) {
            throw new ParameterException("Missing required parameter when creating subaccount level connections. Please specify '-n' or '--name'.");
        }
    }

    private void validateAccountLevelNameIsNotDefault() {
        if (!ApplicationLevelDeterminator.isOnApplicationLevel(this.application) && this.isDefault(this.name)) {
            throw new ParameterException("For subaccount level connections, please specify '-n' or '--name' that is different from 'sap_hcmcloud_core_odata' or 'sap_hcmcloud_core_odata_technical_user'.");
        }
    }

    private boolean isDefault(String name) {
        return SAP_HCMCLOUD_CORE_ODATA.equals(name) || SAP_HCMCLOUD_CORE_ODATA_TECHNICAL_USER.equals(name);
    }
}

