/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.connectivity;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.extensions.service.cmd.client.operation.DeleteConnectionParams;
import com.sap.core.extensions.service.cmd.client.operation.DeletedArtifactsData;
import com.sap.core.extensions.service.cmd.client.operation.Operation;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ApplicationLevelDeterminator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ApplicationParameterAnalyzer;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ConnectionNameValidator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExampleValue;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExtensionsGroupCommand;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.OperationErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.connectivity.ConnectionErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ApplicationParam;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.RequiredField;

@Parameters(commandDescription="1. Removes the connection between a Java application and the extended SAP SuccessFactors instance.\n2. Removes the connection between a subaccount and the extended SAP SuccessFactors instance")
public class DeleteConnectionCommand
extends ExtensionsGroupCommand<DeletedArtifactsData> {
    static final String COMMAND_DESCRIPTION = "1. Removes the connection between a Java application and the extended SAP SuccessFactors instance.\n2. Removes the connection between a subaccount and the extended SAP SuccessFactors instance";
    private static final String COMMAND_NAME = "hcmcloud-delete-connection";
    private static final String EXECUTING_MSG = "Deleting connection...";
    private static final String MISSING_CONNECTION_ON_APPLICATION_LEVEL_MSG = "No connection with name '%s' for subaccount '%s' and application '%s' can be found.";
    private static final String MISSING_CONNECTION_ON_SUBACCOUNT_LEVEL_MSG = "No connection with name '%s' for subaccount '%s' can be found.";
    private static final String BACKEND_ERR_MSG = "Cannot delete connection '%s'. Try again later and if the issue persists, contact SAP support.";
    private static final String APPLICATION_NOT_FOUND_MSG = "Invalid value in parameter --application. Application '%s' was not found in the provided subaccount '%s'.";
    private static final String NOT_EXTENSION_ACCOUNT_MSG = "Cannot delete connection '%s'. Subaccount '%s' is not linked to an SAP SuccessFactors system.";
    private static final String CONSUMER_NOT_SUBSCRIBED_MSG = "Cannot delete connection '%s'. Subaccount '%s' must be subscribed to the application '%s' in the provided subaccount '%s'.";
    @ExampleValue(value="my_extension_application")
    @ApplicationParam(required=false)
    @Parameter(names={"-b", "--application"}, description="The name of the extension application for which you are deleting the connection.\n  Syntax:\n  1. '--application <my_extension_application>' if the application is running in your subaccount;\n  2. '--application <provider_subaccount>:<extension_application>' if the application is running in another subaccount and your extension subaccount is subscribed to the application.")
    private String application;
    @RequiredField
    @ExampleValue(value="sap_hcmcloud_core_odata")
    @Parameter(names={"-n", "--name"}, description="Name of the connection, which you are deleting. Get the list of all connections using hcmcloud-list-connections command.", validateWith=ConnectionNameValidator.class)
    private String name;

    @Override
    protected String getCommandExecutingMessage() {
        return EXECUTING_MSG;
    }

    @Override
    protected String getSuccessMessage(Operation<DeletedArtifactsData> operationResult) {
        StringBuilder successMsgBuilder = new StringBuilder();
        successMsgBuilder.append("Connection to SAP SuccessFactors");
        if (ApplicationLevelDeterminator.isOnApplicationLevel(this.application)) {
            successMsgBuilder.append(" for application '");
            successMsgBuilder.append(this.application);
            successMsgBuilder.append("'");
        }
        successMsgBuilder.append(" in subaccount '");
        successMsgBuilder.append(this.getAccount());
        successMsgBuilder.append("' was deleted successfully.");
        successMsgBuilder.append(LINE_SEPARATOR);
        successMsgBuilder.append("Details:");
        DeletedArtifactsData deletionData = (DeletedArtifactsData)operationResult.getResult();
        String destinationName = deletionData.getDestinationName();
        Boolean destinationDeleted = deletionData.getDestinationDeleted();
        this.addDeletionMsg(successMsgBuilder, "- Destination", destinationName, destinationDeleted, "SAP Cloud Platform");
        String client = deletionData.getOauthClient();
        Boolean clientDeleted = deletionData.getOauthClientDeleted();
        this.addDeletionMsg(successMsgBuilder, "- OAuth 2.0 client", client, clientDeleted, "SAP SuccessFactors");
        return successMsgBuilder.toString();
    }

    @Override
    protected String getNotExtensionAccountErrorMessage() {
        return String.format(NOT_EXTENSION_ACCOUNT_MSG, this.name, this.getAccount());
    }

    @Override
    protected String getBackendErrorMessage() {
        return String.format(BACKEND_ERR_MSG, this.name);
    }

    @Override
    protected void registerCommandSpecificErrors() {
        ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        String providerAccount = appParamAnalyzer.getProviderAccount();
        String applicationName = appParamAnalyzer.getApplicationName();
        this.registerError(OperationErrorCode.APPLICATION_NOT_FOUND, APPLICATION_NOT_FOUND_MSG, applicationName, providerAccount != null ? providerAccount : this.getAccount());
        this.registerError(OperationErrorCode.CONSUMER_NOT_SUBSCRIBED, CONSUMER_NOT_SUBSCRIBED_MSG, this.name, this.getAccount(), applicationName, providerAccount);
        if (ApplicationLevelDeterminator.isOnApplicationLevel(this.application)) {
            this.registerError(ConnectionErrorCode.MISSING_CONNECTION, MISSING_CONNECTION_ON_APPLICATION_LEVEL_MSG, this.name, this.getAccount(), applicationName);
        } else {
            this.registerError(ConnectionErrorCode.MISSING_CONNECTION, MISSING_CONNECTION_ON_SUBACCOUNT_LEVEL_MSG, this.name, this.getAccount());
        }
    }

    public String getName() {
        return COMMAND_NAME;
    }

    private void addDeletionMsg(StringBuilder successMsgBuilder, String deletedType, String deletedName, Boolean deletedString, String deletedFrom) {
        if (null != deletedName && null != deletedString) {
            successMsgBuilder.append(LINE_SEPARATOR);
            successMsgBuilder.append(deletedType);
            successMsgBuilder.append(" '");
            successMsgBuilder.append(deletedName);
            successMsgBuilder.append(this.getDeletionMsg(deletedString, deletedFrom));
        }
    }

    private String getDeletionMsg(boolean deleted, String deletedFrom) {
        if (deleted) {
            return String.format("' was deleted from %s.", deletedFrom);
        }
        return String.format("' was not found in %s.", deletedFrom);
    }

    @Override
    protected long createOperation(String accountId) {
        ApplicationParameterAnalyzer applicationParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        String providerAccount = applicationParamAnalyzer.consumedThroughtSubscription() ? applicationParamAnalyzer.getProviderAccount() : null;
        DeleteConnectionParams params = new DeleteConnectionParams(applicationParamAnalyzer.getApplicationName(), providerAccount, this.name);
        return this.operationsClient.createDeleteConnectionOperation(accountId, params);
    }

    @Override
    protected Operation<DeletedArtifactsData> getOperation(String accountId, long operationId) {
        return this.operationsClient.getDeleteConnectionOperation(accountId, operationId);
    }
}

