/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.connectivity;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.extensions.service.cmd.client.operation.Connection;
import com.sap.core.extensions.service.cmd.client.operation.Operation;
import com.sap.core.extensions.service.cmd.client.operation.SubscriptionParams;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ApplicationParameterAnalyzer;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExampleValue;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExtensionsGroupCommand;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.OperationErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.connectivity.ConnectionListFormatter;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ApplicationParam;
import java.util.List;

@Parameters(commandDescription="1. Returns a list of configured connections for a specified application in a wanted subaccount.\n2. Returns a list of configured connections for a specified subaccount.")
public class ListConnectionsCommand
extends ExtensionsGroupCommand<List<Connection>> {
    static final String COMMAND_DESCRIPTION = "1. Returns a list of configured connections for a specified application in a wanted subaccount.\n2. Returns a list of configured connections for a specified subaccount.";
    private static final String COMMAND_NAME = "hcmcloud-list-connections";
    private static final String EXECUTION_MSG = "Listing connections...";
    private static final String NOT_EXTENSION_ACCOUNT_ERR_MSG = "Cannot list the connections. Subaccount '%s' is not linked to an SAP SuccessFactors system.";
    private static final String APPLICATION_NOT_FOUND_ERR_MSG_PATERN = "Invalid value in parameter --application. Application '%s' was not found in the provided subaccount '%s'.";
    private static final String CUNSUMER_NOT_SUBSCRIBED_MSG_PATTERN = "Cannot list the connections. Subaccount '%s' must be subscribed to the application '%s' in the provided subaccount '%s'.";
    private static final String BACKEND_ERROR = "Cannot list the connections. Try again later and if the issue persists, contact SAP support.";
    private ConnectionListFormatter connectionListFormatter = new ConnectionListFormatter();
    @ExampleValue(value="my_extension_application")
    @ApplicationParam(required=false)
    @Parameter(names={"-b", "--application"}, description="The name of the extension application for which you are listing the connections.\n  Syntax:\n  1. '--application <my_extension_application>' if the application is running in your subaccount;\n  2. '--application <provider_subaccount>:<extension_application>' if the application is running in another subaccount and your extension subaccount is subscribed to the application.")
    private String application;

    @Override
    protected String getCommandExecutingMessage() {
        return EXECUTION_MSG;
    }

    @Override
    protected String getSuccessMessage(Operation<List<Connection>> operationResult) {
        return this.connectionListFormatter.format((List)operationResult.getResult());
    }

    @Override
    protected String getNotExtensionAccountErrorMessage() {
        return String.format(NOT_EXTENSION_ACCOUNT_ERR_MSG, this.getAccount());
    }

    @Override
    protected String getBackendErrorMessage() {
        return BACKEND_ERROR;
    }

    @Override
    protected void registerCommandSpecificErrors() {
        ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        this.registerError(OperationErrorCode.APPLICATION_NOT_FOUND, APPLICATION_NOT_FOUND_ERR_MSG_PATERN, this.application, this.getAccount());
        this.registerError(OperationErrorCode.CONSUMER_NOT_SUBSCRIBED, CUNSUMER_NOT_SUBSCRIBED_MSG_PATTERN, this.getAccount(), appParamAnalyzer.getApplicationName(), appParamAnalyzer.getProviderAccount());
    }

    @Override
    protected Operation<List<Connection>> getOperation(String accountId, long operationId) {
        return this.operationsClient.getListConnectionsOperation(accountId, operationId);
    }

    @Override
    protected long createOperation(String accountId) {
        ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        SubscriptionParams subscriptionParams = new SubscriptionParams(appParamAnalyzer.getApplicationName(), appParamAnalyzer.consumedThroughtSubscription() ? appParamAnalyzer.getProviderAccount() : null);
        return this.operationsClient.createListConnectionsOperation(accountId, subscriptionParams);
    }

    public String getName() {
        return COMMAND_NAME;
    }
}

