/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.roleprovider;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.extensions.service.cmd.client.operation.EnableRoleProviderParams;
import com.sap.core.extensions.service.cmd.client.operation.Operation;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ApplicationParameterAnalyzer;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ConnectionNameValidator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExampleValue;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExtensionsGroupCommand;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.OperationErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.roleprovider.EnableRoleProviderErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ApplicationParam;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.RequiredField;

@Parameters(commandDescription="Enables the SAP SuccessFactors role provider for the specified Java application")
public class EnableRoleProviderCommand
extends ExtensionsGroupCommand<Void> {
    static final String COMMAND_DESCRIPTION = "Enables the SAP SuccessFactors role provider for the specified Java application";
    private static final String COMMAND_NAME = "hcmcloud-enable-role-provider";
    private static final String COMMAND_EXECUTION_MESSAGE = "Enabling role provider...";
    private static final String SUCCESS_MSG_PATTERN = "SAP SuccessFactors role provider was enabled for application '%s'.";
    private static final String APPLICATION_NOT_FOUND_ERR_MSG_PATERN = "Invalid value in parameter --application. Application '%s' was not found in the provided subaccount '%s'.";
    private static final String BACKEND_ERR_MSG = "Cannot enable role provider due to internal error. Try again later and if the issue persists, contact SAP support.";
    private static final String MISSING_DESTINATION_ERR_MSG_PATTERN = "Required '%s' destination for connecting to the SAP SuccessFactors system OData API is missing. Please configure connectivity to the SAP SuccessFactors system.";
    private static final String NOT_EXTENSION_ACCOUNT_ERR_MSG_PATTERN = "Cannot enable role provider feature. Subaccount '%s' must be linked to an SAP SuccessFactors system.";
    private static final String CONSUMER_NOT_SUBSCRIBED_MSG_PATTERN = "Cannot enable role provider. Subaccount '%s' must be subscribed to the application '%s' in the subaccount '%s'.";
    private static final String SAP_HCMCLOUD_CORE_ODATA = "sap_hcmcloud_core_odata";
    @ApplicationParam(required=true)
    @RequiredField
    @ExampleValue(value="my_extension_application")
    @Parameter(names={"--application", "-b"}, description="The name of the extension application for which you are enabling the role provider feature.\n  Syntax:\n  1. '--application <my_extension_application>' if the application is running in your subaccount;\n  2. '--application <provider_subaccount>:<extension_application>' if the application is running in another subaccount and your extension subaccount is subscribed to the application.")
    private String application;
    @Parameter(names={"--connection-name"}, description="The name of the destination for connecting to the SAP SuccessFactors system OData API.", validateWith=ConnectionNameValidator.class)
    @ExampleValue(value="sap_hcmcloud_core_odata")
    private String connectionName;

    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    protected String getCommandExecutingMessage() {
        return COMMAND_EXECUTION_MESSAGE;
    }

    @Override
    protected String getNotExtensionAccountErrorMessage() {
        return String.format(NOT_EXTENSION_ACCOUNT_ERR_MSG_PATTERN, this.getAccount());
    }

    @Override
    protected String getBackendErrorMessage() {
        return BACKEND_ERR_MSG;
    }

    @Override
    protected String getSuccessMessage(Operation<Void> operationResult) {
        return String.format(SUCCESS_MSG_PATTERN, this.application);
    }

    @Override
    protected void registerCommandSpecificErrors() {
        ApplicationParameterAnalyzer applicationParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        String applicationName = applicationParamAnalyzer.getApplicationName();
        String providerAccount = applicationParamAnalyzer.getProviderAccount();
        String consumer = providerAccount == null ? this.account : providerAccount;
        this.registerError(OperationErrorCode.APPLICATION_NOT_FOUND, APPLICATION_NOT_FOUND_ERR_MSG_PATERN, applicationName, consumer);
        this.registerError((ErrorCode)OperationErrorCode.CONSUMER_NOT_SUBSCRIBED, String.format(CONSUMER_NOT_SUBSCRIBED_MSG_PATTERN, this.account, applicationName, providerAccount));
        this.registerError((ErrorCode)EnableRoleProviderErrorCode.MISSING_ODATA_CONNECTION, String.format(MISSING_DESTINATION_ERR_MSG_PATTERN, this.connectionName != null ? this.connectionName : SAP_HCMCLOUD_CORE_ODATA));
    }

    @Override
    protected long createOperation(String accountId) {
        ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        EnableRoleProviderParams enableRoleProviderParams = new EnableRoleProviderParams(appParamAnalyzer.getApplicationName(), appParamAnalyzer.consumedThroughtSubscription() ? appParamAnalyzer.getProviderAccount() : null, this.connectionName);
        return this.operationsClient.createEnableRoleProviderOperation(accountId, enableRoleProviderParams);
    }

    @Override
    protected Operation<Void> getOperation(String accountId, long operationId) {
        return this.operationsClient.getEnableRoleProviderOperation(accountId, operationId);
    }
}

