/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.roles;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.extensions.service.cmd.client.operation.ImportRolesResult;
import com.sap.core.extensions.service.cmd.client.operation.Operation;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ErrorMessageCreator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExampleValue;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExtensionsGroupCommand;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.roles.RBPRole;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.roles.ResultMessageBuilder;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.roles.RolesErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.FileParam;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.RequiredField;

@Parameters(commandDescription="Imports SAP SuccessFactors HCM suite roles into the SAP SuccessFactors customer instance linked to an extension subaccount.")
public class ImportRolesCommand
extends ExtensionsGroupCommand<ImportRolesResult> {
    static final String COMMAND_DESCRIPTION = "Imports SAP SuccessFactors HCM suite roles into the SAP SuccessFactors customer instance linked to an extension subaccount.";
    private static final String COMMAND_NAME = "hcmcloud-import-roles";
    private static final String EXECUTING_MESSAGE = "Importing roles...";
    private static final String NOT_EXTENSION_ACCOUNT_ERR_MSG_PATTERN = "Cannot import roles. Subaccount '%s' must be linked to an SAP SuccessFactors system.";
    private static final String INVALID_RESOURCE_FILE_ERROR_MSG = "The specified roles file does not contain a valid HCM role definitions. Specify a file with valid JSON content.";
    private static final String NO_ROLES_IN_RESOURCE_ERROR_MSG = "There are no roles defined in the provided file. Please provide at least one role.";
    private static final String DUPLICATE_ROLES_RESOURCE_ERROR_MSG = "The provided file contains HCM role definitions with duplicate names. Please make sure all roles have unique names.";
    private static final String BACKEND_ERR_MSG = "Cannot import roles. Try again later and if the issue persists, contact SAP support.";
    @RequiredField
    @FileParam(maxSize=500L, jsonType=RBPRole[].class)
    @ExampleValue(value="C:\\roles.json")
    @Parameter(names={"-l", "--location"}, description="Path to a file with role definitions")
    private String rolesFilePath;

    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    protected String getCommandExecutingMessage() {
        return EXECUTING_MESSAGE;
    }

    @Override
    protected String getNotExtensionAccountErrorMessage() {
        return String.format(NOT_EXTENSION_ACCOUNT_ERR_MSG_PATTERN, this.account);
    }

    @Override
    protected String getBackendErrorMessage() {
        return BACKEND_ERR_MSG;
    }

    @Override
    protected void registerCommandSpecificErrors() {
        this.registerError((ErrorCode)RolesErrorCode.INVALID_RESOURCE_FILE, INVALID_RESOURCE_FILE_ERROR_MSG);
        this.registerError((ErrorCode)RolesErrorCode.NO_ROLES_IN_RESOURCE, NO_ROLES_IN_RESOURCE_ERROR_MSG);
        this.registerError((ErrorCode)RolesErrorCode.DUPLICATE_ROLES_IN_RESOURCE, DUPLICATE_ROLES_RESOURCE_ERROR_MSG);
        this.registerError((ErrorCode)RolesErrorCode.PARTIAL_IMPORT, new ErrorMessageCreator<ImportRolesResult>(){

            @Override
            public String create(Operation<ImportRolesResult> operationResult) {
                ResultMessageBuilder resultMessageBuilder = new ResultMessageBuilder(ImportRolesCommand.this.account, (ImportRolesResult)operationResult.getResult());
                return resultMessageBuilder.buildErrorMessage();
            }
        });
    }

    @Override
    protected long createOperation(String accountId) {
        return this.operationsClient.createImportRolesOperation(accountId, this.rolesFilePath);
    }

    @Override
    protected Operation<ImportRolesResult> getOperation(String accountId, long operationId) {
        return this.operationsClient.getImportRolesOperation(accountId, operationId);
    }

    @Override
    protected String getSuccessMessage(Operation<ImportRolesResult> operationResult) {
        return new ResultMessageBuilder(this.account, (ImportRolesResult)operationResult.getResult()).buildSuccessMessage();
    }
}

