/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.roles;

import com.sap.core.extensions.service.cmd.client.operation.ImportRolesResult;
import java.util.Set;

class ResultMessageBuilder {
    private static final String BASE_WARNING_PATTERN = "(!) WARNING: %s:";
    private static final String BASE_ERROR_PATTERN = "(!) ERROR: %s:";
    private static final String BASE_SUCCESS_MSG = "%d role(s) out of %d have been successfully imported in the SAP SuccessFactors instance associated with subaccount '%s'.";
    private static final String BASE_ERROR_MSG = "%d role(s) out of %d could not be imported in the SAP SuccessFactors instance associated with subaccount '%s'.";
    private static final String EXISTING_ROLES_WARNING_MSG = "The following roles already exist in the SAP SuccessFactors system and were not imported";
    private static final String PERMISSIONS_MISMATCH_WARNING_MSG = "The following roles contain permissions which do not exist in the target SAP SuccessFactors system and were not imported";
    private static final String FAILED_ROLES_WARNING_MSG = "The following roles could not be imported";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String DEFAULT_PROPS_ALIGN_FORMAT = "  %s";
    private final ImportRolesResult result;
    private final String account;

    ResultMessageBuilder(String account, ImportRolesResult result) {
        this.account = account;
        this.result = result;
    }

    String buildSuccessMessage() {
        return this.buildMessage(BASE_SUCCESS_MSG, this.result.getImportedCount());
    }

    String buildErrorMessage() {
        int failedRoles = this.result.getAllRolesCount() - this.result.getImportedCount();
        return this.buildMessage(BASE_ERROR_MSG, failedRoles);
    }

    private String buildMessage(String baseMsg, int rolesMsgCount) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format(baseMsg, rolesMsgCount, this.result.getAllRolesCount(), this.account));
        ResultMessageBuilder.appendMsg(builder, BASE_ERROR_PATTERN, PERMISSIONS_MISMATCH_WARNING_MSG, this.result.getUnresolvedPermissionsRoles());
        ResultMessageBuilder.appendMsg(builder, BASE_ERROR_PATTERN, FAILED_ROLES_WARNING_MSG, this.result.getFailedImportRoles());
        ResultMessageBuilder.appendMsg(builder, BASE_WARNING_PATTERN, EXISTING_ROLES_WARNING_MSG, this.result.getExistingRoles());
        builder.append(LINE_SEPARATOR);
        return builder.toString();
    }

    private static void appendMsg(StringBuilder builder, String msgType, String message, Set<String> roles) {
        if (roles == null || roles.isEmpty()) {
            return;
        }
        builder.append(LINE_SEPARATOR);
        builder.append(LINE_SEPARATOR);
        builder.append(String.format(msgType, message));
        for (String roleName : roles) {
            builder.append(LINE_SEPARATOR);
            builder.append(String.format(DEFAULT_PROPS_ALIGN_FORMAT, roleName));
        }
    }
}

