/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.tiles;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.extensions.service.cmd.client.operation.ApplicationType;
import com.sap.core.extensions.service.cmd.client.operation.ListTilesResultDTO;
import com.sap.core.extensions.service.cmd.client.operation.Operation;
import com.sap.core.extensions.service.cmd.client.operation.TypeApplicationParams;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ApplicationParameterAnalyzer;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ApplicationTypeValidator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExampleValue;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExtensionsGroupCommand;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.OperationErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.tiles.ListTilesResultMessage;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.tiles.TilesErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ApplicationParam;

@Parameters(commandDescription="Lists the registered SAP SuccessFactors Home Page tiles served by a specified Java or HTML5 Application")
public class ListTilesCommand
extends ExtensionsGroupCommand<ListTilesResultDTO> {
    static final String LIST_TILES_COMMAND_DESC = "Lists the registered SAP SuccessFactors Home Page tiles served by a specified Java or HTML5 Application";
    private static final String LIST_HOME_PAGE_TILES_CMD_NAME = "hcmcloud-get-registered-home-page-tiles";
    private static final String LIST_HOME_PAGE_TILES_EXECUTION_MSG = "Listing Home Page Tiles...";
    private static final String NOT_AN_EXTENSION_ACCOUNT_ERR_MSG = "Cannot fetch SAP SuccessFactors home page tiles. Subaccount '%s' is not linked to an SAP SuccessFactors system";
    private static final String CONSUMER_NOT_SUBSCRIBED_ERR_MSG = "Cannot register SAP SuccessFactors home page tiles. Subaccount '%s' must be subscribed to application '%s'.";
    private static final String BACKEND_ERR_MSG = "Cannot list SAP SuccessFactors home page tiles. Try again later and if the issue persists contact SAP support";
    private static final String MISSING_APPLICATION_ERR_MSG = "'%s' application '%s' is not found in subaccount '%s'.";
    private static final String INVALID_LOCALE_ERR_MSG = "Cannot list SAP SuccessFactors home page tiles. Tile definition contains a tile with an invalid tile locale.";
    private static final String ROLE_NOT_FOUND_ERR_MSG = "Cannot list SAP SuccessFactors home page tiles. Tile definition contains roles that cannot be found in the SAP SuccessFactors system linked to '%s'.";
    @ExampleValue(value="java")
    @Parameter(names={"--application-type"}, description="Type of the application. Valid values are 'java' or 'html5'. Default value is 'java'.", validateWith=ApplicationTypeValidator.class)
    private String applicationType;
    @ApplicationParam(required=false)
    @ExampleValue(value="ordersapplication")
    @Parameter(names={"-b", "--application"}, description="Name of the extension application serving the tiles.\n  Syntax:\n  1. '--application <myapp>' if the application runs in your subaccount;\n  2. '--application <provider_subaccount>:<provider_app>' if the application runs in another subaccount")
    private String application;

    @Override
    protected String getCommandExecutingMessage() {
        return LIST_HOME_PAGE_TILES_EXECUTION_MSG;
    }

    @Override
    protected String getSuccessMessage(Operation<ListTilesResultDTO> operationResult) {
        ListTilesResultMessage resultMessage = new ListTilesResultMessage();
        return resultMessage.buildSuccessMessage((ListTilesResultDTO)operationResult.getResult());
    }

    @Override
    protected String getNotExtensionAccountErrorMessage() {
        return String.format(NOT_AN_EXTENSION_ACCOUNT_ERR_MSG, this.account);
    }

    @Override
    protected String getBackendErrorMessage() {
        return BACKEND_ERR_MSG;
    }

    @Override
    protected void registerCommandSpecificErrors() {
        if (this.application != null && !this.application.isEmpty()) {
            ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
            String targetAccount = null != appParamAnalyzer.getProviderAccount() ? appParamAnalyzer.getProviderAccount() : this.account;
            String appName = appParamAnalyzer.getApplicationName();
            this.registerError(OperationErrorCode.APPLICATION_NOT_FOUND, MISSING_APPLICATION_ERR_MSG, this.getAppType().getConsoleValue(), appName, targetAccount);
            this.registerError(OperationErrorCode.CONSUMER_NOT_SUBSCRIBED, CONSUMER_NOT_SUBSCRIBED_ERR_MSG, this.account, appName);
        }
        this.registerError((ErrorCode)TilesErrorCode.INVALID_LOCALE, INVALID_LOCALE_ERR_MSG);
        this.registerError(TilesErrorCode.ROLE_NOT_FOUND, ROLE_NOT_FOUND_ERR_MSG, this.account);
    }

    public String getName() {
        return LIST_HOME_PAGE_TILES_CMD_NAME;
    }

    @Override
    protected long createOperation(String accountId) {
        String applicationName = null;
        String providerAccountId = null;
        ApplicationType appType = null;
        if (this.application != null && !this.application.isEmpty()) {
            ApplicationParameterAnalyzer applicationParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
            applicationName = applicationParamAnalyzer.getApplicationName();
            if (applicationParamAnalyzer.consumedThroughtSubscription()) {
                providerAccountId = applicationParamAnalyzer.getProviderAccount();
            }
            appType = this.getAppType();
        }
        TypeApplicationParams params = new TypeApplicationParams(applicationName, providerAccountId, appType);
        return this.operationsClient.createListTilesOperation(accountId, params);
    }

    private ApplicationType getAppType() {
        if (this.applicationType == null || this.applicationType.isEmpty()) {
            return ApplicationType.JAVA;
        }
        return (ApplicationType)ApplicationType.getConsoleValues().get(this.applicationType);
    }

    @Override
    protected Operation<ListTilesResultDTO> getOperation(String accountId, long operationId) {
        return this.operationsClient.getListTilesOperation(accountId, operationId);
    }
}

