/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.tiles;

import com.sap.core.extensions.service.cmd.client.operation.ListTileInfoDTO;
import com.sap.core.extensions.service.cmd.client.operation.ListTilesResultDTO;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ParamFormatter;
import java.util.List;

public class ListTilesResultMessage {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private ParamFormatter versionParamFormatter = new ParamFormatter("%20s - %s");
    private ParamFormatter tileParamFormatter = new ParamFormatter("%20s : %s");

    public String buildSuccessMessage(ListTilesResultDTO result) {
        StringBuilder resultMessage = new StringBuilder();
        List tiles = result.getTilesInfo();
        if (tiles == null || tiles.isEmpty()) {
            return "No registered tiles were found in SAP SuccessFactors home page.";
        }
        resultMessage.append("The following registered tiles were found in SAP SuccessFactors home page:");
        resultMessage.append(LINE_SEPARATOR);
        resultMessage.append(LINE_SEPARATOR);
        resultMessage.append(LINE_SEPARATOR);
        String homePageVersionName = result.getHomePageVersion().getDisplayName();
        resultMessage.append(this.versionParamFormatter.formatParam("Home Page Version", homePageVersionName));
        resultMessage.append(LINE_SEPARATOR);
        resultMessage.append(LINE_SEPARATOR);
        for (ListTileInfoDTO tile : tiles) {
            resultMessage.append(this.tileParamFormatter.formatParam("Tile Name", tile.getTileName())).append(LINE_SEPARATOR);
            resultMessage.append(this.tileParamFormatter.formatParam("Status", tile.getTileStatus().getDisplayName())).append(LINE_SEPARATOR);
            resultMessage.append(LINE_SEPARATOR);
        }
        return resultMessage.toString();
    }
}

