/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.tiles;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.sap.core.extensions.service.cmd.client.operation.ApplicationType;
import com.sap.core.extensions.service.cmd.client.operation.Operation;
import com.sap.core.extensions.service.cmd.client.operation.RegisterTilesResultDTO;
import com.sap.core.extensions.service.cmd.client.operation.TypeApplicationParams;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ApplicationParameterAnalyzer;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ApplicationTypeValidator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ErrorMessageCreator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExampleValue;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExtensionsGroupCommand;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.OperationErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.tiles.RegisterTilesResultMessage;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.tiles.TilesErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ApplicationParam;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.FileParam;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.RequiredField;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

@Parameters(commandDescription="Registers home page tiles from a file containing tile definitions, into an SAP SuccessFactors instance linked to the specified subaccount.")
public class RegisterTileCommand
extends ExtensionsGroupCommand<RegisterTilesResultDTO> {
    static final String REGISTER_TILE_COMMAND_DESC = "Registers home page tiles from a file containing tile definitions, into an SAP SuccessFactors instance linked to the specified subaccount.";
    private static final String REGISTER_HOME_PAGE_TILE_EXECUTION_MSG = "Registering Home Page tiles...";
    private static final String REGISTER_HOME_PAGE_TILE_CMD_NAME = "hcmcloud-register-home-page-tiles";
    private static final String CONFLICTING_TILES_KEY = "conflictingTiles";
    private static final String APPLICATION_NOT_STARTED_ERR_MSG = "'%s' application '%s' is not started.";
    private static final String BACKEND_ERR_MSG = "Cannot register SAP SuccessFactors Home Page tiles. Try again later and if the issue persists contact SAP support.";
    private static final String CONSUMER_NOT_SUBSCRIBED_ERR_MSG = "Cannot register SAP SuccessFactors Home Page tiles. Subaccount '%s' must be subscribed to application '%s'.";
    private static final String INVALID_LOCALE_ERR_MSG = "Cannot register SAP SuccessFactors Home Page tiles. Tile definition contains a tile with an invalid tile locale.";
    private static final String INVALID_TILE_DEFINITION_ERR_MSG = "The specified file does not contain a valid HCM tile definitions. Specify a file with valid JSON content.";
    private static final String NOT_AN_EXTENSION_ACCOUNT_ERR_MSG = "Cannot import SAP SuccessFactors Home Page tiles. Subaccount '%s' must be linked to an SAP SuccessFactors system.";
    private static final String MAXIMUM_TILE_QUOTA_REACHED_ERR_MSG = "Cannot register SAP SuccessFactors Home Page tiles. Maximum tile quota is reached.";
    private static final String MISSING_APPLICATION_ERR_MSG = "'%s' application '%s' is not found in subaccount '%s'.";
    private static final String LOCATION_NOT_FOUND_ERR_MSG = "Could not find location '%s' for the given resource. Check if:%s\t1. The location is spelled correctly.%s\t2. The resource contains a tiles.json file.";
    private static final String ROLE_NOT_FOUND_ERR_MSG = "Cannot register SAP SuccessFactors Home Page tiles. Tile definition contains roles that cannot be found in the SAP SuccessFactors system linked to '%s'.";
    private static final String NO_TILES_IN_RESOURCE_ERROR_MSG = "There are no tiles defined in the provided file. Please provide at least one tile.";
    private static final String NO_SUPPORTED_TILES_PROVIDED_ERR_MSG = "The provided tiles do not match the supported version of SAP SuccessFactors Home Page tiles.";
    private static final String TILES_CONFLICT_ERR_MSG_TEMPLATE = "Tile(s) %s already exist(s) for other applications.";
    private static final String TILES_CONFLICT_ERR_MSG = "Tile(s) already exist(s) for other applications.";
    @RequiredField
    @ExampleValue(value="myapplication")
    @ApplicationParam(required=true)
    @Parameter(names={"-b", "--application"}, description="Name of the extension application serving the tiles.\n  Syntax:\n  1. '--application <myapp>' if the application runs in your subaccount;\n  2. '--application <provider_subaccount>:<provider_app>' if the application runs in another subaccount")
    private String application;
    @ExampleValue(value="java")
    @Parameter(names={"--application-type"}, description="Type of the application. Valid values are 'java' or 'html5'. Default value is 'java'.", validateWith=ApplicationTypeValidator.class)
    private String applicationType;
    @RequiredField
    @FileParam(maxSize=100L, jsonType=JsonArray.class)
    @ExampleValue(value="C:\\tiles.json")
    @Parameter(names={"-l", "--location"}, description="Location of the tile resource file in which the tiles are defined.")
    private String location;

    public String getName() {
        return REGISTER_HOME_PAGE_TILE_CMD_NAME;
    }

    @Override
    protected String getNotExtensionAccountErrorMessage() {
        return String.format(NOT_AN_EXTENSION_ACCOUNT_ERR_MSG, this.account);
    }

    @Override
    protected String getBackendErrorMessage() {
        return BACKEND_ERR_MSG;
    }

    @Override
    protected String getCommandExecutingMessage() {
        return REGISTER_HOME_PAGE_TILE_EXECUTION_MSG;
    }

    @Override
    protected void registerCommandSpecificErrors() {
        ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        String targetAccount = null != appParamAnalyzer.getProviderAccount() ? appParamAnalyzer.getProviderAccount() : this.account;
        String appName = appParamAnalyzer.getApplicationName();
        this.applicationType = this.getAppType().getConsoleValue();
        String locationNotFoundErrMessage = String.format(LOCATION_NOT_FOUND_ERR_MSG, this.location, LINE_SEPARATOR, LINE_SEPARATOR);
        this.registerError((ErrorCode)TilesErrorCode.LOCATION_NOT_FOUND, locationNotFoundErrMessage);
        this.registerError(TilesErrorCode.APPLICATION_NOT_STARTED, APPLICATION_NOT_STARTED_ERR_MSG, this.applicationType, appName);
        this.registerError((ErrorCode)TilesErrorCode.INVALID_TILE_DEFINITION, INVALID_TILE_DEFINITION_ERR_MSG);
        this.registerError((ErrorCode)TilesErrorCode.TILES_QUOTA_EXCEEDED, MAXIMUM_TILE_QUOTA_REACHED_ERR_MSG);
        this.registerError((ErrorCode)TilesErrorCode.INVALID_LOCALE, INVALID_LOCALE_ERR_MSG);
        this.registerError(TilesErrorCode.ROLE_NOT_FOUND, ROLE_NOT_FOUND_ERR_MSG, this.account);
        this.registerError((ErrorCode)TilesErrorCode.NO_TILES_IN_RESOURCE, NO_TILES_IN_RESOURCE_ERROR_MSG);
        this.registerError((ErrorCode)TilesErrorCode.MISSING_SECTIONS, new MissingSectionsErrorMessageCreator());
        this.registerError((ErrorCode)TilesErrorCode.NO_SUPPORTED_TILES_PROVIDED, NO_SUPPORTED_TILES_PROVIDED_ERR_MSG);
        this.registerError((ErrorCode)TilesErrorCode.TILES_CONFLICT, new ConflictingTilesErrorMessageCreator());
        this.registerError(OperationErrorCode.APPLICATION_NOT_FOUND, MISSING_APPLICATION_ERR_MSG, this.applicationType, appName, targetAccount);
        this.registerError(OperationErrorCode.CONSUMER_NOT_SUBSCRIBED, CONSUMER_NOT_SUBSCRIBED_ERR_MSG, this.account, appName);
    }

    @Override
    protected long createOperation(String accountId) {
        ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        String providerAccount = appParamAnalyzer.consumedThroughtSubscription() ? appParamAnalyzer.getProviderAccount() : null;
        this.applicationType = this.getAppType().getConsoleValue();
        ApplicationType appType = ApplicationType.valueOf((String)this.applicationType.toUpperCase());
        TypeApplicationParams applicationParams = new TypeApplicationParams(appParamAnalyzer.getApplicationName(), providerAccount, appType);
        return this.operationsClient.createRegisterTilesOperation(accountId, applicationParams, this.location);
    }

    @Override
    protected Operation<RegisterTilesResultDTO> getOperation(String accountId, long operationId) {
        return this.operationsClient.getRegisterTilesOperation(accountId, operationId);
    }

    @Override
    protected String getSuccessMessage(Operation<RegisterTilesResultDTO> operationResult) {
        this.applicationType = this.getAppType().getConsoleValue();
        RegisterTilesResultDTO result = (RegisterTilesResultDTO)operationResult.getResult();
        RegisterTilesResultMessage registerTilesResultMessage = new RegisterTilesResultMessage();
        return registerTilesResultMessage.buildSuccessMessage(result, this.applicationType, this.application);
    }

    protected ApplicationType getAppType() {
        if (this.applicationType == null || this.applicationType.isEmpty()) {
            return ApplicationType.JAVA;
        }
        return (ApplicationType)ApplicationType.getConsoleValues().get(this.applicationType);
    }

    private static class MissingSectionsErrorMessageCreator
    implements ErrorMessageCreator<RegisterTilesResultDTO> {
        private static final String MISSING_SECTIONS_KEY = "missingSectionIds";

        private MissingSectionsErrorMessageCreator() {
        }

        @Override
        public String create(Operation<RegisterTilesResultDTO> operationResult) {
            Map errorParameters = operationResult.getErrorParameters();
            if (null == errorParameters || !errorParameters.containsKey(MISSING_SECTIONS_KEY)) {
                return "Missing section(s).";
            }
            String missingSectionIdsJSON = (String)errorParameters.get(MISSING_SECTIONS_KEY);
            TreeSet missingSectionIds = (TreeSet)new Gson().fromJson(missingSectionIdsJSON, new TypeToken<TreeSet<String>>(){}.getType());
            return String.format("Missing section(s) %s.", missingSectionIds);
        }
    }

    private static class ConflictingTilesErrorMessageCreator
    implements ErrorMessageCreator<RegisterTilesResultDTO> {
        private ConflictingTilesErrorMessageCreator() {
        }

        @Override
        public String create(Operation<RegisterTilesResultDTO> operationResult) {
            Map errorParameters = operationResult.getErrorParameters();
            if (errorParameters == null || !errorParameters.containsKey(RegisterTileCommand.CONFLICTING_TILES_KEY)) {
                return RegisterTileCommand.TILES_CONFLICT_ERR_MSG;
            }
            String conflictingTilesJson = (String)errorParameters.get(RegisterTileCommand.CONFLICTING_TILES_KEY);
            Type setOfStringsType = new TypeToken<Set<String>>(){}.getType();
            try {
                Set conflictingTiles = (Set)new Gson().fromJson(conflictingTilesJson, setOfStringsType);
                return String.format(RegisterTileCommand.TILES_CONFLICT_ERR_MSG_TEMPLATE, conflictingTiles.toString());
            }
            catch (JsonSyntaxException e) {
                return RegisterTileCommand.TILES_CONFLICT_ERR_MSG;
            }
        }
    }
}

