/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.tiles;

import com.sap.core.extensions.service.cmd.client.operation.TileRegistrationStatus;
import java.util.List;
import java.util.Map;

public class RegisterTilesPrinter {
    private static final String ALIGN_FORMAT_STATUS = "%20s :";
    private static final String ALIGN_FORMAT_TILE_NAME = "%22s%s";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public String print(Map<TileRegistrationStatus, List<String>> actionToTiles) {
        StringBuilder tilesListing = new StringBuilder();
        for (Map.Entry<TileRegistrationStatus, List<String>> entry : actionToTiles.entrySet()) {
            TileRegistrationStatus status = entry.getKey();
            String statusTitle = String.format(ALIGN_FORMAT_STATUS, status.getAction());
            tilesListing.append(statusTitle).append(LINE_SEPARATOR);
            List<String> tiles = entry.getValue();
            for (String tileName : tiles) {
                tileName = String.format(ALIGN_FORMAT_TILE_NAME, " ", tileName);
                tilesListing.append(tileName).append(LINE_SEPARATOR);
            }
            tilesListing.append(LINE_SEPARATOR);
        }
        return tilesListing.toString();
    }
}

