/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.tiles;

import com.sap.core.extensions.service.cmd.client.operation.HomePageVersion;
import com.sap.core.extensions.service.cmd.client.operation.RegisterTileInfoDTO;
import com.sap.core.extensions.service.cmd.client.operation.RegisterTilesResultDTO;
import com.sap.core.extensions.service.cmd.client.operation.TileRegistrationStatus;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ParamFormatter;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.tiles.RegisterTilesPrinter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class RegisterTilesResultMessage {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public String buildSuccessMessage(RegisterTilesResultDTO result, String applicationType, String application) {
        StringBuilder resultMessage = new StringBuilder();
        ParamFormatter paramFormatter = new ParamFormatter("%20s - %s");
        HomePageVersion homePageVersion = result.getHomePageVersion();
        List tilesInfo = result.getTilesInfo();
        String successMessage = tilesInfo.size() == 1 ? "%d tile was modified in SAP SuccessFactors home page for '%s' application '%s'." : "%d tiles were modified in SAP SuccessFactors home page for '%s' application '%s'.";
        resultMessage.append(String.format(successMessage, tilesInfo.size(), applicationType, application));
        resultMessage.append(LINE_SEPARATOR);
        resultMessage.append(LINE_SEPARATOR);
        resultMessage.append(LINE_SEPARATOR);
        resultMessage.append(paramFormatter.formatParam("Home Page Version", homePageVersion.getDisplayName()));
        resultMessage.append(LINE_SEPARATOR);
        resultMessage.append(LINE_SEPARATOR);
        resultMessage.append(this.printTiles(tilesInfo));
        return resultMessage.toString();
    }

    private String printTiles(List<RegisterTileInfoDTO> tilesInfo) {
        RegisterTilesPrinter tilePrinter = new RegisterTilesPrinter();
        return tilePrinter.print(this.getSortedTiles(tilesInfo));
    }

    private Map<TileRegistrationStatus, List<String>> getSortedTiles(List<RegisterTileInfoDTO> tilesInfo) {
        TreeMap<TileRegistrationStatus, List<String>> sortedTiles = new TreeMap<TileRegistrationStatus, List<String>>();
        for (RegisterTileInfoDTO tile : tilesInfo) {
            TileRegistrationStatus status = tile.getStatus();
            String currentTileName = tile.getName();
            if (!sortedTiles.containsKey(status)) {
                sortedTiles.put(status, new LinkedList());
            }
            ((List)sortedTiles.get(status)).add(currentTileName);
        }
        return sortedTiles;
    }
}

