/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.tiles;

import com.sap.core.extensions.service.cmd.client.operation.SuccessFactorsTile;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ParamFormatter;
import java.util.List;

public class TilePrinter {
    private static final String PROPS_ALIGN_FORMAT = "   %-10s : %s";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String TILE_NAME_DISPLAY_PROPERTY = "Tile Name";
    private static final String TILE_URL_DISPLAY_PROPERTY = "Tile URL";
    private static final String TILE_SIZE_DISPLAY_PROPERTY = "Size";
    private static final String TILE_PADDING_DISPLAY_PROPERTY = "Padding";
    private List<SuccessFactorsTile> tiles;
    private final ParamFormatter paramFormatter = new ParamFormatter("   %-10s : %s");

    public TilePrinter(List<SuccessFactorsTile> tiles) {
        this.tiles = tiles;
    }

    public String print() {
        if (this.tiles.isEmpty()) {
            return "";
        }
        StringBuilder tilesListing = new StringBuilder();
        for (SuccessFactorsTile tile : this.tiles) {
            tilesListing.append(this.paramFormatter.formatParam(TILE_NAME_DISPLAY_PROPERTY, tile.getName())).append(LINE_SEPARATOR);
            tilesListing.append(this.paramFormatter.formatParam(TILE_URL_DISPLAY_PROPERTY, tile.getContentUrl())).append(LINE_SEPARATOR);
            tilesListing.append(this.paramFormatter.formatParam(TILE_SIZE_DISPLAY_PROPERTY, tile.getSize())).append(LINE_SEPARATOR);
            tilesListing.append(this.paramFormatter.formatParam(TILE_PADDING_DISPLAY_PROPERTY, tile.getPadding())).append(LINE_SEPARATOR);
            tilesListing.append(LINE_SEPARATOR);
        }
        return tilesListing.toString();
    }
}

