/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.tiles;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.extensions.service.cmd.client.operation.ApplicationType;
import com.sap.core.extensions.service.cmd.client.operation.Operation;
import com.sap.core.extensions.service.cmd.client.operation.TypeApplicationParams;
import com.sap.core.extensions.service.cmd.client.operation.UnregisterTilesResultDTO;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ApplicationParameterAnalyzer;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ApplicationTypeValidator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExampleValue;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ExtensionsGroupCommand;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.OperationErrorCode;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.tiles.UnregisterTilesResultMessage;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ApplicationParam;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.RequiredField;

@Parameters(commandDescription="Unregisters all previously registered SAP SuccessFactors home page tiles served by the specified Java or HTML5 application.")
public class UnregisterTilesCommand
extends ExtensionsGroupCommand<UnregisterTilesResultDTO> {
    protected static final String COMMAND_DESCRIPTION = "Unregisters all previously registered SAP SuccessFactors home page tiles served by the specified Java or HTML5 application.";
    private static final String COMMAND_NAME = "hcmcloud-unregister-home-page-tiles";
    private static final String OPERATIONS_NAME = "hcmcloud-unregister-home-page-tiles";
    private static final String COMMAND_EXECUTION_MSG = "Unregistering tiles...";
    private static final String NOT_EXTENSION_ACCOUNT_MSG = "Cannot unregister SAP SuccessFactors home page tiles. Subaccount '%s' is not linked to an SAP SuccessFactors system.";
    private static final String APPLICATION_NOT_FOUND_MSG = "Invalid value in parameter --application. Application '%s' was not found in subaccount '%s'.";
    private static final String CONSUMER_NOT_SUBSCRIBED_MSG = "Cannot unregister SAP SuccessFactors home page tiles. Subaccount '%s' must be subscribed to application '%s' from provider subaccount '%s'.";
    private static final String BACKEND_FAILURE_MSG = "Cannot unregister SAP SuccessFactors home page tiles. Try again later and if the issue persists, contact SAP support.";
    @ApplicationParam(required=true)
    @RequiredField
    @ExampleValue(value="myapplication")
    @Parameter(names={"-b", "--application"}, description="Name of the extension application serving the tiles.\n  Syntax:\n  1. '--application <myapp>' if the application runs in your subaccount;\n  2. '--application <provider_subaccount>:<provider_app>' if the application runs in another subaccount")
    private String application;
    @ExampleValue(value="java")
    @Parameter(names={"--application-type"}, description="Type of the application. Valid values are 'java' or 'html5'. Default value is 'java'.", validateWith=ApplicationTypeValidator.class)
    private String applicationType;

    @Override
    protected String getCommandExecutingMessage() {
        return COMMAND_EXECUTION_MSG;
    }

    @Override
    protected String getSuccessMessage(Operation<UnregisterTilesResultDTO> operationResult) {
        UnregisterTilesResultMessage resultMessage = new UnregisterTilesResultMessage();
        return resultMessage.buildSuccessMessage((UnregisterTilesResultDTO)operationResult.getResult());
    }

    @Override
    protected String getNotExtensionAccountErrorMessage() {
        return String.format(NOT_EXTENSION_ACCOUNT_MSG, this.getAccount());
    }

    @Override
    protected String getBackendErrorMessage() {
        return BACKEND_FAILURE_MSG;
    }

    @Override
    protected void registerCommandSpecificErrors() {
        ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        String providerAccount = appParamAnalyzer.getProviderAccount();
        String applicationName = appParamAnalyzer.getApplicationName();
        this.registerError(OperationErrorCode.APPLICATION_NOT_FOUND, APPLICATION_NOT_FOUND_MSG, applicationName, this.getAccount());
        this.registerError(OperationErrorCode.CONSUMER_NOT_SUBSCRIBED, CONSUMER_NOT_SUBSCRIBED_MSG, this.getAccount(), applicationName, providerAccount);
    }

    public String getName() {
        return "hcmcloud-unregister-home-page-tiles";
    }

    @Override
    protected long createOperation(String accountId) {
        ApplicationParameterAnalyzer appParamAnalyzer = new ApplicationParameterAnalyzer(this.application);
        String providerAccount = appParamAnalyzer.consumedThroughtSubscription() ? appParamAnalyzer.getProviderAccount() : null;
        TypeApplicationParams params = new TypeApplicationParams(appParamAnalyzer.getApplicationName(), providerAccount, this.getAppType());
        return this.operationsClient.createUnregisterTilesOperation(accountId, params);
    }

    private ApplicationType getAppType() {
        if (this.applicationType == null || this.applicationType.isEmpty()) {
            return ApplicationType.JAVA;
        }
        return (ApplicationType)ApplicationType.getConsoleValues().get(this.applicationType);
    }

    @Override
    protected Operation<UnregisterTilesResultDTO> getOperation(String accountId, long operationId) {
        return this.operationsClient.getUnregisterTilesOperation(accountId, operationId);
    }
}

