/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.tiles;

import com.sap.core.extensions.service.cmd.client.operation.TileGroupDTO;
import com.sap.core.extensions.service.cmd.client.operation.UnregisterTileInfoDTO;
import com.sap.core.extensions.service.cmd.client.operation.UnregisterTilesResultDTO;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ParamFormatter;
import java.util.List;

public class UnregisterTilesResultMessage {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private ParamFormatter versionParamFormatter = new ParamFormatter("%20s - %s");
    private ParamFormatter tileParamFormatter = new ParamFormatter("%20s : %s");

    public String buildSuccessMessage(UnregisterTilesResultDTO result) {
        StringBuilder resultMessage = new StringBuilder();
        List deletedTiles = result.getDeletedTiles();
        if (this.isDeletedTilesEmpty(deletedTiles)) {
            return "No tiles were unregistered from SAP SuccessFactors home page.";
        }
        resultMessage.append("The following tiles were unregistered from SAP SuccessFactors home page:");
        resultMessage.append(LINE_SEPARATOR);
        resultMessage.append(LINE_SEPARATOR);
        resultMessage.append(LINE_SEPARATOR);
        for (TileGroupDTO tileGroup : deletedTiles) {
            resultMessage.append(this.versionParamFormatter.formatParam("Home Page Version", tileGroup.getHomePageVersion().getDisplayName()));
            resultMessage.append(LINE_SEPARATOR);
            resultMessage.append(LINE_SEPARATOR);
            for (UnregisterTileInfoDTO tileInfo : tileGroup.getTilesInfo()) {
                resultMessage.append(this.tileParamFormatter.formatParam("Tile Name", tileInfo.getTileName())).append(LINE_SEPARATOR);
            }
            resultMessage.append(LINE_SEPARATOR);
            resultMessage.append(LINE_SEPARATOR);
        }
        return resultMessage.toString();
    }

    private boolean isDeletedTilesEmpty(List<TileGroupDTO> deletedTiles) {
        if (deletedTiles == null) {
            return true;
        }
        for (TileGroupDTO deletedTileGroup : deletedTiles) {
            List tilesInfo = deletedTileGroup.getTilesInfo();
            if (tilesInfo == null || tilesInfo.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

