/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.validation;

import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ApplicationParam;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ParameterAnnotationValidator;

public class ApplicationParamValidator
extends ParameterAnnotationValidator<ApplicationParam, String> {
    private static final String APPLICATION_REGEX = "^[a-z][a-z0-9]{0,29}(:[a-z][a-z0-9]{0,29})?$";
    private static final String ERR_MESSAGE_PATTERN = "The application parameter value '%s' is not valid. It must contain only lowercase letters (a-z), digits (0-9) or colons (:), and must start with a lowercase letter. The value must be no longer than 30 characters. In case it specifies a subscribed application (account:app), both account and application must be no longer than 30 characters each.";

    public ApplicationParamValidator() {
        super(ApplicationParam.class, String.class);
    }

    @Override
    protected boolean isValidFieldValue(String value, ApplicationParam applicationParamAnnotation) {
        boolean hasValidValue;
        boolean isBlankValue = null == value || 0 == value.trim().length();
        boolean bl = hasValidValue = !isBlankValue && value.matches(APPLICATION_REGEX);
        if (applicationParamAnnotation.required()) {
            return hasValidValue;
        }
        return isBlankValue ? true : hasValidValue;
    }

    @Override
    protected String createErrorMessage(String fieldValue, String formattedParamNames, ApplicationParam validationAnnotation) {
        return String.format(ERR_MESSAGE_PATTERN, fieldValue);
    }
}

