/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.validation;

import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.FileParam;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ParameterAnnotationValidator;
import java.io.File;

public class FileExistenceValidator
extends ParameterAnnotationValidator<FileParam, String> {
    private static final String ERR_MSG_PATTERN = "Value '%s' for parameter '%s' is not a valid file path. Provide a valid file path.";

    public FileExistenceValidator() {
        super(FileParam.class, String.class);
    }

    @Override
    protected boolean isValidFieldValue(String filePath, FileParam annotation) {
        File file = new File(filePath);
        return file.isFile();
    }

    @Override
    protected String createErrorMessage(String fieldValue, String formattedParamNames, FileParam validationAnnotation) {
        return String.format(ERR_MSG_PATTERN, fieldValue, formattedParamNames);
    }
}

