/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.validation;

import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.FileParam;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ParameterAnnotationValidator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.UnexpectedParamValueException;
import java.io.File;

public class FileSizeValidator
extends ParameterAnnotationValidator<FileParam, String> {
    private static final int BYTES_IN_KILOBYTE = 1024;
    private static final String ERR_MSG_PATTERN = "File '%s' exceeds the size limit. The maximum supported file size is %dKB.";

    public FileSizeValidator() {
        super(FileParam.class, String.class);
    }

    @Override
    protected boolean isValidFieldValue(String filePath, FileParam annotation) {
        File file = new File(filePath);
        long maxSize = annotation.maxSize();
        long maxSizeInBytes = maxSize * 1024L;
        if (!file.isFile()) {
            String errMsg = String.format("Provided file parameter value '%s' is not a valid file.", filePath);
            throw new UnexpectedParamValueException(errMsg);
        }
        return file.length() <= maxSizeInBytes;
    }

    @Override
    protected String createErrorMessage(String fieldValue, String formattedParamNames, FileParam validationAnnotation) {
        return String.format(ERR_MSG_PATTERN, fieldValue, validationAnnotation.maxSize());
    }
}

