/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.validation;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.FileParam;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ListParameterizedType;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ParamValueException;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ParameterAnnotationValidator;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.UnexpectedParamValueException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class JsonFileValidator
extends ParameterAnnotationValidator<FileParam, String> {
    private static final Logger LOGGER = Logger.getLogger(JsonFileValidator.class);
    private static final String ERR_MSG_PATTERN = "The content of file '%s' is not valid. Provide a file with valid JSON content.";
    private final Gson gson = new Gson();

    public JsonFileValidator() {
        super(FileParam.class, String.class);
    }

    @Override
    protected boolean isValidFieldValue(String filePath, FileParam annotation) {
        String fileContent = this.getFileContent(filePath);
        Type jsonType = this.extractType(annotation);
        try {
            JsonElement jsonElement = new JsonParser().parse(fileContent);
            if (JsonArray.class == jsonType) {
                return jsonElement instanceof JsonArray;
            }
            if (JsonObject.class == jsonType) {
                return jsonElement instanceof JsonObject;
            }
            Object deserializedBean = this.gson.fromJson(jsonElement, jsonType);
            return null != deserializedBean;
        }
        catch (JsonParseException ex) {
            LOGGER.error((Object)("Invalid json format in file " + filePath), (Throwable)ex);
            return false;
        }
    }

    private String getFileContent(String filePath) {
        File jsonFile = this.getFile(filePath);
        try {
            return FileUtils.readFileToString((File)jsonFile);
        }
        catch (IOException ex) {
            throw new ParamValueException("Failed to read file content of file with path " + filePath, ex);
        }
    }

    private File getFile(String filePath) {
        File jsonFile = new File(filePath);
        if (!jsonFile.isFile()) {
            String errMsg = String.format("Provided file parameter value '%s' is not a valid file.", filePath);
            throw new UnexpectedParamValueException(errMsg);
        }
        return jsonFile;
    }

    private Type extractType(FileParam annotation) {
        Class<?> jsonClass = annotation.jsonType();
        if (jsonClass.isArray()) {
            Class<?> arrayComponentsClass = jsonClass.getComponentType();
            return new ListParameterizedType(arrayComponentsClass);
        }
        return jsonClass;
    }

    @Override
    protected String createErrorMessage(String fieldValue, String formattedParamNames, FileParam validationAnnotation) {
        return String.format(ERR_MSG_PATTERN, fieldValue);
    }
}

