/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.commands.hcmcloud.validation;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.ParameterFieldsExtractor;
import com.sap.core.extensions.service.cmd.commands.hcmcloud.validation.ParamValidator;
import com.sap.jpaas.infrastructure.console.command.AccountCommand;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;

public abstract class ParameterAnnotationValidator<T extends Annotation, V>
implements ParamValidator {
    private static final String OR = " or";
    private static final String COMMA = ",";
    private static final String EMPTY_STRING = "";
    private static final String BRACKERS_REGEX = "\\[|\\]";
    private static final String MISSING_PARAM_ANNOTATION_ERR_MSG = "Missing parameter annotation.";
    private final ParameterFieldsExtractor parameterFieldsExtractor;
    private final Class<T> annotationClass;
    private final Class<V> fieldClass;

    public ParameterAnnotationValidator(Class<T> annotationClass, Class<V> fieldClass) {
        this(annotationClass, fieldClass, new ParameterFieldsExtractor());
    }

    ParameterAnnotationValidator(Class<T> annotationClass, Class<V> fieldClass, ParameterFieldsExtractor parameterFieldsExtractor) {
        this.annotationClass = annotationClass;
        this.parameterFieldsExtractor = parameterFieldsExtractor;
        this.fieldClass = fieldClass;
    }

    @Override
    public void validate(AccountCommand<?> cmd) throws ParameterException {
        Field[] instanceFields;
        for (Field field : instanceFields = this.parameterFieldsExtractor.extract(cmd)) {
            if (!field.isAnnotationPresent(this.annotationClass)) continue;
            this.validateField(field, cmd);
        }
    }

    protected void validateField(Field field, AccountCommand<?> cmd) {
        T validationAnnotation;
        V fieldValue = this.getFieldValue(field, cmd);
        if (!this.isValidFieldValue(fieldValue, validationAnnotation = field.getAnnotation(this.annotationClass))) {
            String formattedParamNames = this.getFormattedParamNames(field);
            String errorMessage = this.createErrorMessage(fieldValue, formattedParamNames, validationAnnotation);
            throw new ParameterException(errorMessage);
        }
    }

    private V getFieldValue(Field field, AccountCommand<?> cmd) {
        if (field.getType() != this.fieldClass) {
            String errMessage = String.format("Invalid field type '%s'. Annotation '%s' should be added only on type '%s'", field.getType().getName(), this.annotationClass.getName(), this.fieldClass.getName());
            throw new IllegalStateException(errMessage);
        }
        try {
            field.setAccessible(true);
            Object errMessage = field.get(cmd);
            return (V)errMessage;
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException("Failed to get field value.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Failed to get field value.", ex);
        }
        finally {
            field.setAccessible(false);
        }
    }

    protected abstract boolean isValidFieldValue(V var1, T var2);

    private String getFormattedParamNames(Field field) {
        Object[] paramNames = this.getParamNames(field);
        if (paramNames.length == 0) {
            throw new ParameterException(MISSING_PARAM_ANNOTATION_ERR_MSG);
        }
        return Arrays.toString(paramNames).replaceAll(BRACKERS_REGEX, EMPTY_STRING).replace(COMMA, OR);
    }

    private String[] getParamNames(Field field) {
        Parameter parameterAnnotation = field.getAnnotation(Parameter.class);
        return parameterAnnotation.names();
    }

    protected abstract String createErrorMessage(V var1, String var2, T var3);
}

