/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.annotation.ManagedBean;
import javax.ejb.EJBContext;
import javax.ejb.TimerService;
import javax.ejb.spi.HandleDelegate;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceContext;
import org.apache.openejb.Injection;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.SystemException;
import org.apache.openejb.assembler.classic.ContextReferenceInfo;
import org.apache.openejb.assembler.classic.EjbLocalReferenceInfo;
import org.apache.openejb.assembler.classic.EjbReferenceInfo;
import org.apache.openejb.assembler.classic.EjbResolver;
import org.apache.openejb.assembler.classic.EnvEntryInfo;
import org.apache.openejb.assembler.classic.InjectableInfo;
import org.apache.openejb.assembler.classic.InjectionInfo;
import org.apache.openejb.assembler.classic.JndiBuilder;
import org.apache.openejb.assembler.classic.JndiEncInfo;
import org.apache.openejb.assembler.classic.LazyEjbReference;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.PersistenceBuilder;
import org.apache.openejb.assembler.classic.PersistenceContextReferenceInfo;
import org.apache.openejb.assembler.classic.PersistenceUnitReferenceInfo;
import org.apache.openejb.assembler.classic.PortRefInfo;
import org.apache.openejb.assembler.classic.ReferenceLocationInfo;
import org.apache.openejb.assembler.classic.ResourceEnvReferenceInfo;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.assembler.classic.ResourceReferenceInfo;
import org.apache.openejb.assembler.classic.ServiceReferenceInfo;
import org.apache.openejb.assembler.classic.WsBuilder;
import org.apache.openejb.core.CoreUserTransaction;
import org.apache.openejb.core.JndiFactory;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.core.TransactionSynchronizationRegistryWrapper;
import org.apache.openejb.core.ivm.naming.ClassReference;
import org.apache.openejb.core.ivm.naming.CrossClassLoaderJndiReference;
import org.apache.openejb.core.ivm.naming.IntraVmJndiReference;
import org.apache.openejb.core.ivm.naming.JaxWsServiceReference;
import org.apache.openejb.core.ivm.naming.JndiReference;
import org.apache.openejb.core.ivm.naming.JndiUrlReference;
import org.apache.openejb.core.ivm.naming.LazyObjectReference;
import org.apache.openejb.core.ivm.naming.MapObjectReference;
import org.apache.openejb.core.ivm.naming.ObjectReference;
import org.apache.openejb.core.ivm.naming.PersistenceContextReference;
import org.apache.openejb.core.ivm.naming.Reference;
import org.apache.openejb.core.ivm.naming.SystemComponentReference;
import org.apache.openejb.core.ivm.naming.URLReference;
import org.apache.openejb.core.webservices.HandlerChainData;
import org.apache.openejb.core.webservices.PortRefData;
import org.apache.openejb.core.webservices.ServiceRefData;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.persistence.JtaEntityManager;
import org.apache.openejb.persistence.JtaEntityManagerRegistry;
import org.apache.openejb.rest.ThreadLocalContextManager;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.Classes;
import org.apache.openejb.util.IntrospectionSupport;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.InjectableBeanManager;

public class JndiEncBuilder {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, JndiEncBuilder.class.getPackage().getName());
    private final boolean beanManagedTransactions;
    private final JndiEncInfo jndiEnc;
    private final URI moduleUri;
    private final String moduleId;
    private final String uniqueId;
    private final Collection<Injection> injections;
    private final ClassLoader classLoader;
    private final Properties properties;
    private boolean useCrossClassLoaderRef = true;
    private boolean client;

    public JndiEncBuilder(JndiEncInfo jndiEnc, Collection<Injection> injections, String moduleId, URI moduleUri, String uniqueId, ClassLoader classLoader, Properties properties) throws OpenEJBException {
        this(jndiEnc, injections, null, moduleId, moduleUri, uniqueId, classLoader, properties);
    }

    public JndiEncBuilder(JndiEncInfo jndiEnc, Collection<Injection> injections, String transactionType, String moduleId, URI moduleUri, String uniqueId, ClassLoader classLoader, Properties properties) throws OpenEJBException {
        this.jndiEnc = jndiEnc;
        this.properties = properties;
        this.injections = injections;
        this.beanManagedTransactions = transactionType != null && transactionType.equalsIgnoreCase("Bean");
        this.moduleId = moduleId;
        this.moduleUri = moduleUri;
        this.uniqueId = uniqueId;
        this.classLoader = classLoader;
    }

    public boolean isUseCrossClassLoaderRef() {
        return this.useCrossClassLoaderRef;
    }

    public void setUseCrossClassLoaderRef(boolean useCrossClassLoaderRef) {
        this.useCrossClassLoaderRef = useCrossClassLoaderRef;
    }

    public boolean isClient() {
        return this.client;
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    public Context build(JndiScope type) throws OpenEJBException {
        Map<String, Object> bindings = this.buildBindings(type);
        return this.build(bindings);
    }

    public Context build(Map<String, Object> bindings) throws SystemException {
        JndiFactory jndiFactory = SystemInstance.get().getComponent(JndiFactory.class);
        if (SystemInstance.get().hasProperty("openejb.geronimo")) {
            return jndiFactory.createComponentContext(new HashMap<String, Object>());
        }
        return jndiFactory.createComponentContext(bindings);
    }

    public Map<String, Object> buildBindings(JndiScope type) throws OpenEJBException {
        Map<String, Object> bindings = this.buildMap(type);
        switch (type) {
            case comp: {
                this.addSpecialCompBindings(bindings);
                break;
            }
            case module: {
                this.addSpecialModuleBindings(bindings);
                break;
            }
            case app: {
                this.addSpecialAppBindings(bindings);
                break;
            }
            case global: {
                this.addSpecialGlobalBindings(bindings);
            }
        }
        return bindings;
    }

    public Map<String, Object> buildMap(JndiScope scope) throws OpenEJBException {
        Reference reference;
        String jndiName;
        Object reference2;
        Class type;
        String jndiName2;
        Reference reference3;
        TreeMap<String, Object> bindings = new TreeMap<String, Object>();
        JtaEntityManagerRegistry jtaEntityManagerRegistry = SystemInstance.get().getComponent(JtaEntityManagerRegistry.class);
        for (EjbReferenceInfo ejbReferenceInfo : this.jndiEnc.ejbReferences) {
            if (ejbReferenceInfo.location != null) {
                Reference reference32 = this.buildReferenceLocation(ejbReferenceInfo.location);
            } else if (ejbReferenceInfo.ejbDeploymentId == null) {
                reference3 = new LazyEjbReference(new Ref(ejbReferenceInfo), this.moduleUri, this.useCrossClassLoaderRef);
            } else {
                String jndiName22 = "openejb/Deployment/" + JndiBuilder.format(ejbReferenceInfo.ejbDeploymentId, ejbReferenceInfo.interfaceClassName, ejbReferenceInfo.localbean ? InterfaceType.LOCALBEAN : InterfaceType.BUSINESS_REMOTE);
                reference3 = this.useCrossClassLoaderRef && ejbReferenceInfo.externalReference ? new CrossClassLoaderJndiReference(jndiName22) : new IntraVmJndiReference(jndiName22);
            }
            bindings.put(this.normalize(ejbReferenceInfo.referenceName), (Object)reference3);
        }
        for (EjbReferenceInfo ejbReferenceInfo : this.jndiEnc.ejbLocalReferences) {
            if (ejbReferenceInfo.location != null) {
                reference3 = this.buildReferenceLocation(ejbReferenceInfo.location);
            } else if (ejbReferenceInfo.ejbDeploymentId == null) {
                reference3 = new LazyEjbReference(new Ref(ejbReferenceInfo), this.moduleUri, false);
            } else {
                jndiName2 = "openejb/Deployment/" + JndiBuilder.format(ejbReferenceInfo.ejbDeploymentId, ejbReferenceInfo.interfaceClassName, ejbReferenceInfo.localbean ? InterfaceType.LOCALBEAN : InterfaceType.BUSINESS_LOCAL);
                reference3 = new IntraVmJndiReference(jndiName2);
            }
            bindings.put(this.normalize(ejbReferenceInfo.referenceName), (Object)reference3);
        }
        for (EnvEntryInfo envEntryInfo : this.jndiEnc.envEntries) {
            if (envEntryInfo.location != null) {
                reference3 = this.buildReferenceLocation(envEntryInfo.location);
                bindings.put(this.normalize(envEntryInfo.referenceName), (Object)reference3);
                continue;
            }
            if (envEntryInfo.value == null) continue;
            try {
                Object obj;
                type = Classes.deprimitivize(this.getType(envEntryInfo.type, envEntryInfo));
                if (type == String.class) {
                    obj = new String(envEntryInfo.value);
                } else if (type == Double.class) {
                    obj = new Double(envEntryInfo.value);
                } else if (type == Integer.class) {
                    obj = new Integer(envEntryInfo.value);
                } else if (type == Long.class) {
                    obj = new Long(envEntryInfo.value);
                } else if (type == Float.class) {
                    obj = new Float(envEntryInfo.value);
                } else if (type == Short.class) {
                    obj = new Short(envEntryInfo.value);
                } else if (type == Boolean.class) {
                    obj = Boolean.valueOf(envEntryInfo.value);
                } else if (type == Byte.class) {
                    obj = new Byte(envEntryInfo.value);
                } else if (type == Character.class) {
                    StringBuilder sb = new StringBuilder(envEntryInfo.value + " ");
                    obj = new Character(sb.charAt(0));
                } else if (type == URL.class) {
                    obj = new URL(envEntryInfo.value);
                } else if (type == Class.class) {
                    obj = new ClassReference(envEntryInfo.value.trim());
                } else if (type.isEnum()) {
                    obj = Enum.valueOf(type, envEntryInfo.value.trim());
                } else {
                    throw new IllegalArgumentException("Invalid env-entry-type " + type);
                }
                bindings.put(this.normalize(envEntryInfo.referenceName), obj);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("The env-entry-value for entry " + envEntryInfo.referenceName + " was not recognizable as type " + envEntryInfo.type + ". Received Message: " + e.getLocalizedMessage(), e);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("URL for reference " + envEntryInfo.referenceName + " was not a valid URL: " + envEntryInfo.value, e);
            }
        }
        for (ResourceReferenceInfo resourceReferenceInfo : this.jndiEnc.resourceRefs) {
            if (!(resourceReferenceInfo instanceof ContextReferenceInfo)) {
                if (resourceReferenceInfo.location != null) {
                    reference3 = this.buildReferenceLocation(resourceReferenceInfo.location);
                    bindings.put(this.normalize(resourceReferenceInfo.referenceName), (Object)reference3);
                    continue;
                }
                type = this.getType(resourceReferenceInfo.referenceType, resourceReferenceInfo);
                if (URL.class.equals((Object)type)) {
                    reference2 = new URLReference(resourceReferenceInfo.resourceID);
                } else if (type.isAnnotationPresent(ManagedBean.class)) {
                    ManagedBean managed = type.getAnnotation(ManagedBean.class);
                    String name = managed.value().length() == 0 ? type.getSimpleName() : managed.value();
                    reference2 = new LinkRef("module/" + name);
                } else if (resourceReferenceInfo.resourceID != null) {
                    jndiName = "openejb/Resource/" + resourceReferenceInfo.resourceID;
                    reference2 = new IntraVmJndiReference(jndiName);
                } else {
                    jndiName = "openejb/Resource/" + resourceReferenceInfo.referenceName;
                    reference2 = new IntraVmJndiReference(jndiName);
                }
                bindings.put(this.normalize(resourceReferenceInfo.referenceName), reference2);
                continue;
            }
            type = this.getType(resourceReferenceInfo.referenceType, resourceReferenceInfo);
            if (Request.class.equals((Object)type)) {
                ObjectReference reference22 = new ObjectReference(ThreadLocalContextManager.REQUEST);
            } else {
                reference2 = HttpServletRequest.class.equals((Object)type) ? new ObjectReference(ThreadLocalContextManager.HTTP_SERVLET_REQUEST) : (ServletRequest.class.equals((Object)type) ? new ObjectReference(ThreadLocalContextManager.SERVLET_REQUEST) : (UriInfo.class.equals((Object)type) ? new ObjectReference(ThreadLocalContextManager.URI_INFO) : (HttpHeaders.class.equals((Object)type) ? new ObjectReference(ThreadLocalContextManager.HTTP_HEADERS) : (SecurityContext.class.equals((Object)type) ? new ObjectReference(ThreadLocalContextManager.SECURITY_CONTEXT) : (ContextResolver.class.equals((Object)type) ? new ObjectReference(ThreadLocalContextManager.CONTEXT_RESOLVER) : (Providers.class.equals((Object)type) ? new ObjectReference(ThreadLocalContextManager.PROVIDERS) : (ServletConfig.class.equals((Object)type) ? new ObjectReference(ThreadLocalContextManager.SERVLET_CONFIG) : (ServletContext.class.equals((Object)type) ? new ObjectReference(ThreadLocalContextManager.SERVLET_CONTEXT) : (HttpServletResponse.class.equals((Object)type) ? new ObjectReference(ThreadLocalContextManager.HTTP_SERVLET_RESPONSE) : (javax.ws.rs.container.ResourceInfo.class.equals((Object)type) ? new ObjectReference(ThreadLocalContextManager.RESOURCE_INFO) : (ResourceContext.class.equals((Object)type) ? new ObjectReference(ThreadLocalContextManager.RESOURCE_CONTEXT) : (Configuration.class.equals((Object)type) ? new ObjectReference(ThreadLocalContextManager.CONFIGURATION) : new MapObjectReference(ThreadLocalContextManager.OTHERS, resourceReferenceInfo.referenceType)))))))))))));
            }
            bindings.put(this.normalize(resourceReferenceInfo.referenceName), reference2);
        }
        for (ResourceEnvReferenceInfo resourceEnvReferenceInfo : this.jndiEnc.resourceEnvRefs) {
            if (resourceEnvReferenceInfo.location != null) {
                reference3 = this.buildReferenceLocation(resourceEnvReferenceInfo.location);
                bindings.put(this.normalize(resourceEnvReferenceInfo.referenceName), (Object)reference3);
                continue;
            }
            type = this.getType(resourceEnvReferenceInfo.resourceEnvRefType, resourceEnvReferenceInfo);
            if (EJBContext.class.isAssignableFrom(type)) {
                jndiName = "comp/EJBContext";
                reference2 = new LinkRef("comp/EJBContext");
                if ("comp/EJBContext".equals(resourceEnvReferenceInfo.referenceName)) {
                    continue;
                }
            } else if (Validator.class.equals((Object)type)) {
                jndiName = "comp/Validator";
                reference2 = new LinkRef("comp/Validator");
            } else if (ValidatorFactory.class.equals((Object)type)) {
                jndiName = "comp/ValidatorFactory";
                reference2 = new LinkRef("comp/ValidatorFactory");
            } else if (WebServiceContext.class.equals((Object)type)) {
                jndiName = "comp/WebServiceContext";
                reference2 = new LinkRef("comp/WebServiceContext");
            } else if (TimerService.class.equals((Object)type)) {
                jndiName = "comp/TimerService";
                reference2 = new LinkRef("comp/TimerService");
            } else if (BeanManager.class.equals((Object)type)) {
                reference2 = new LazyObjectReference<BeanManager>(new Callable<BeanManager>(){

                    @Override
                    public BeanManager call() throws Exception {
                        return new InjectableBeanManager(WebBeansContext.currentInstance().getBeanManagerImpl());
                    }
                });
            } else if (UserTransaction.class.equals((Object)type)) {
                reference2 = new IntraVmJndiReference("comp/UserTransaction");
            } else if (resourceEnvReferenceInfo.resourceID != null) {
                jndiName = "openejb/Resource/" + resourceEnvReferenceInfo.resourceID;
                reference2 = new IntraVmJndiReference(jndiName);
            } else {
                jndiName = "openejb/Resource/" + resourceEnvReferenceInfo.referenceName;
                reference2 = new IntraVmJndiReference(jndiName);
            }
            bindings.put(this.normalize(resourceEnvReferenceInfo.referenceName), reference2);
        }
        for (PersistenceUnitReferenceInfo persistenceUnitReferenceInfo : this.jndiEnc.persistenceUnitRefs) {
            if (persistenceUnitReferenceInfo.location != null) {
                reference3 = this.buildReferenceLocation(persistenceUnitReferenceInfo.location);
                bindings.put(this.normalize(persistenceUnitReferenceInfo.referenceName), (Object)reference3);
                continue;
            }
            String jndiName3 = PersistenceBuilder.getOpenEJBJndiName(persistenceUnitReferenceInfo.unitId);
            reference2 = new IntraVmJndiReference(jndiName3);
            bindings.put(this.normalize(persistenceUnitReferenceInfo.referenceName), reference2);
        }
        for (PersistenceContextReferenceInfo persistenceContextReferenceInfo : this.jndiEnc.persistenceContextRefs) {
            EntityManagerFactory factory;
            if (persistenceContextReferenceInfo.location != null) {
                reference3 = this.buildReferenceLocation(persistenceContextReferenceInfo.location);
                bindings.put(this.normalize(persistenceContextReferenceInfo.referenceName), (Object)reference3);
                continue;
            }
            Context context = SystemInstance.get().getComponent(ContainerSystem.class).getJNDIContext();
            try {
                jndiName = PersistenceBuilder.getOpenEJBJndiName(persistenceContextReferenceInfo.unitId);
                factory = (EntityManagerFactory)context.lookup(jndiName);
            }
            catch (NamingException e) {
                throw new OpenEJBException("PersistenceUnit '" + persistenceContextReferenceInfo.unitId + "' not found for EXTENDED ref '" + persistenceContextReferenceInfo.referenceName + "'");
            }
            JtaEntityManager jtaEntityManager = new JtaEntityManager(persistenceContextReferenceInfo.persistenceUnitName, jtaEntityManagerRegistry, factory, persistenceContextReferenceInfo.properties, persistenceContextReferenceInfo.extended, persistenceContextReferenceInfo.synchronizationType);
            reference = new PersistenceContextReference(jtaEntityManager);
            bindings.put(this.normalize(persistenceContextReferenceInfo.referenceName), (Object)reference);
        }
        for (ServiceReferenceInfo serviceReferenceInfo : this.jndiEnc.serviceRefs) {
            URL wsdlUrl;
            Class<?> referenceClass;
            Class<Service> serviceClass;
            block92: {
                if (serviceReferenceInfo.location != null) {
                    reference3 = this.buildReferenceLocation(serviceReferenceInfo.location);
                    bindings.put(this.normalize(serviceReferenceInfo.referenceName), (Object)reference3);
                    continue;
                }
                serviceClass = Service.class;
                if (serviceReferenceInfo.serviceType != null) {
                    try {
                        serviceClass = this.classLoader.loadClass(serviceReferenceInfo.serviceType).asSubclass(Service.class);
                    }
                    catch (Exception e) {
                        throw new OpenEJBException("Could not load service type class " + serviceReferenceInfo.serviceType, e);
                    }
                }
                referenceClass = null;
                if (serviceReferenceInfo.referenceType != null) {
                    try {
                        referenceClass = this.classLoader.loadClass(serviceReferenceInfo.referenceType);
                    }
                    catch (Exception e) {
                        throw new OpenEJBException("Could not load reference type class " + serviceReferenceInfo.referenceType, e);
                    }
                }
                if (referenceClass != null && Service.class.isAssignableFrom(referenceClass)) {
                    serviceClass = referenceClass.asSubclass(Service.class);
                }
                wsdlUrl = null;
                if (serviceReferenceInfo.wsdlFile != null) {
                    try {
                        wsdlUrl = new URL(serviceReferenceInfo.wsdlFile);
                    }
                    catch (MalformedURLException e) {
                        wsdlUrl = this.classLoader.getResource(serviceReferenceInfo.wsdlFile);
                        if (wsdlUrl != null) break block92;
                        logger.warning("Error obtaining WSDL: " + serviceReferenceInfo.wsdlFile, e);
                    }
                }
            }
            ArrayList<PortRefData> portRefs = new ArrayList<PortRefData>(serviceReferenceInfo.portRefs.size());
            for (PortRefInfo portRefInfo : serviceReferenceInfo.portRefs) {
                PortRefData portRef = new PortRefData();
                portRef.setQName(portRefInfo.qname);
                portRef.setServiceEndpointInterface(portRefInfo.serviceEndpointInterface);
                portRef.setEnableMtom(portRefInfo.enableMtom);
                portRef.getProperties().putAll((Map<?, ?>)portRefInfo.properties);
                portRefs.add(portRef);
            }
            List<HandlerChainData> handlerChains = null;
            if (!serviceReferenceInfo.handlerChains.isEmpty()) {
                handlerChains = WsBuilder.toHandlerChainData(serviceReferenceInfo.handlerChains, this.classLoader);
            }
            if (!this.client) {
                JaxWsServiceReference reference4 = new JaxWsServiceReference(serviceReferenceInfo.id, serviceReferenceInfo.serviceQName, serviceClass, serviceReferenceInfo.portQName, referenceClass, wsdlUrl, portRefs, handlerChains, this.injections, this.properties);
                bindings.put(this.normalize(serviceReferenceInfo.referenceName), (Object)reference4);
                continue;
            }
            ServiceRefData serviceRefData = new ServiceRefData(serviceReferenceInfo.id, serviceReferenceInfo.serviceQName, serviceClass, serviceReferenceInfo.portQName, referenceClass, wsdlUrl, handlerChains, portRefs);
            bindings.put(this.normalize(serviceReferenceInfo.referenceName), serviceRefData);
        }
        OpenEjbConfiguration config = SystemInstance.get().getComponent(OpenEjbConfiguration.class);
        if (config != null) {
            for (ResourceInfo resource : config.facilities.resources) {
                jndiName2 = resource.jndiName;
                if (jndiName2 == null || jndiName2.isEmpty() || !this.isNotGobalOrIsHoldByThisApp(resource, scope)) continue;
                String refName = "openejb/Resource/" + resource.id;
                reference = new IntraVmJndiReference(refName);
                String boundName = this.normalize(jndiName2);
                bindings.put(boundName, (Object)reference);
            }
        }
        return bindings;
    }

    private boolean isNotGobalOrIsHoldByThisApp(ResourceInfo info, JndiScope scope) {
        return !info.jndiName.startsWith("global/") || info.originAppName != null && info.originAppName.equals(this.moduleId) && JndiScope.global.equals((Object)scope);
    }

    private void addSpecialCompBindings(Map<String, Object> bindings) {
        TransactionManager transactionManager = SystemInstance.get().getComponent(TransactionManager.class);
        bindings.put("comp/TransactionManager", transactionManager);
        bindings.put("comp/TransactionSynchronizationRegistry", new TransactionSynchronizationRegistryWrapper());
        try {
            bindings.put("comp/ORB", (Object)new SystemComponentReference(ParentClassLoaderFinder.Helper.get().loadClass("org.omg.CORBA.ORB")));
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
        bindings.put("comp/HandleDelegate", (Object)new SystemComponentReference(HandleDelegate.class));
        bindings.put("comp/ValidatorFactory", (Object)new IntraVmJndiReference("openejb/ValidatorFactory/" + this.uniqueId));
        bindings.put("comp/Validator", (Object)new IntraVmJndiReference("openejb/Validator/" + this.uniqueId));
        if (this.beanManagedTransactions) {
            CoreUserTransaction userTransaction = new CoreUserTransaction(transactionManager);
            bindings.put("comp/UserTransaction", userTransaction);
        }
    }

    private void addSpecialModuleBindings(Map<String, Object> bindings) {
        if (this.moduleId != null) {
            bindings.put("module/ModuleName", this.moduleId);
        }
        if (bindings.isEmpty()) {
            bindings.put("module/dummy", "dummy");
        }
    }

    private void addSpecialAppBindings(Map<String, Object> bindings) {
        if (this.moduleId != null) {
            bindings.put("app/AppName", this.moduleId);
        }
        if (bindings.isEmpty()) {
            bindings.put("app/dummy", "dummy");
        }
    }

    private void addSpecialGlobalBindings(Map<String, Object> bindings) {
        if (bindings.isEmpty()) {
            bindings.put("global/dummy", "dummy");
        }
    }

    public static boolean bindingExists(Context context, Name contextName) {
        try {
            return context.lookup(contextName) != null;
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    private Reference buildReferenceLocation(ReferenceLocationInfo location) {
        if (location.jndiProviderId != null) {
            String subContextName = "openejb/remote_jndi_contexts/" + location.jndiProviderId;
            return new JndiReference(subContextName, location.jndiName);
        }
        return new JndiUrlReference(location.jndiName);
    }

    private String normalize(String name) {
        return name;
    }

    private Class getType(String type, InjectableInfo injectable) throws OpenEJBException {
        if (type != null) {
            try {
                return this.classLoader.loadClass(type.trim());
            }
            catch (ClassNotFoundException e) {
                throw new OpenEJBException("Unable to load type '" + type + "' for " + injectable.referenceName);
            }
        }
        return this.inferType(injectable);
    }

    private Class inferType(InjectableInfo injectable) throws OpenEJBException {
        for (InjectionInfo injection : injectable.targets) {
            try {
                Class<?> target = this.classLoader.loadClass(injection.className.trim());
                return IntrospectionSupport.getPropertyType(target, injection.propertyName.trim());
            }
            catch (ClassNotFoundException | NoSuchFieldException reflectiveOperationException) {
            }
        }
        throw new OpenEJBException("Unable to infer type for " + injectable.referenceName);
    }

    private static class Ref
    implements EjbResolver.Reference,
    Serializable {
        private final EjbReferenceInfo info;

        public Ref(EjbReferenceInfo info) {
            this.info = info;
        }

        @Override
        public String getEjbLink() {
            return this.info.link;
        }

        @Override
        public String getHome() {
            return this.info.homeClassName;
        }

        @Override
        public String getInterface() {
            return this.info.interfaceClassName;
        }

        @Override
        public String getMappedName() {
            return null;
        }

        @Override
        public String getName() {
            return this.info.referenceName;
        }

        @Override
        public EjbResolver.Type getRefType() {
            if (this.info instanceof EjbLocalReferenceInfo) {
                return EjbResolver.Type.LOCAL;
            }
            if (this.info.homeClassName != null) {
                return EjbResolver.Type.REMOTE;
            }
            return EjbResolver.Type.UNKNOWN;
        }
    }

    public static enum JndiScope {
        comp,
        module,
        app,
        global;

    }
}

